"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestPipelineFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _test_pipeline_tabs = require("./test_pipeline_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestPipelineFlyout = ({
  handleTestPipeline,
  resetTestOutput,
  isRunningTest,
  cachedVerbose,
  cachedDocuments,
  testOutput,
  form,
  validateAndTestPipeline,
  selectedTab,
  setSelectedTab,
  testingError,
  onClose
}) => {
  let tabContent;
  const pipelineTitleId = (0, _eui.useGeneratedHtmlId)();
  if (selectedTab === 'output') {
    tabContent = /*#__PURE__*/_react.default.createElement(_test_pipeline_tabs.OutputTab, {
      handleTestPipeline: handleTestPipeline,
      isRunningTest: isRunningTest,
      cachedVerbose: cachedVerbose,
      cachedDocuments: cachedDocuments,
      testOutput: testOutput
    });
  } else {
    // default to "Documents" tab
    tabContent = /*#__PURE__*/_react.default.createElement(_test_pipeline_tabs.DocumentsTab, {
      form: form,
      validateAndTestPipeline: validateAndTestPipeline,
      isRunningTest: isRunningTest,
      resetTestOutput: resetTestOutput
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: 550,
    onClose: onClose,
    "data-test-subj": "testPipelineFlyout",
    "aria-labelledby": pipelineTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "title",
    id: pipelineTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.testPipelineFlyout.title",
    defaultMessage: "Test pipeline"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_test_pipeline_tabs.Tabs, {
    onTabChange: async nextTab => {
      if (nextTab === 'output') {
        // When switching to the output tab,
        // we automatically run the pipeline if documents are defined
        validateAndTestPipeline();
      } else {
        form.reset({
          defaultValue: {
            documents: cachedDocuments
          }
        });
        setSelectedTab(nextTab);
      }
    },
    selectedTab: selectedTab
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), testingError ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.testPipelineFlyout.executePipelineError",
      defaultMessage: "Unable to execute pipeline"
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "pipelineExecutionError"
  }, /*#__PURE__*/_react.default.createElement("p", null, testingError.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, tabContent));
};
exports.TestPipelineFlyout = TestPipelineFlyout;