"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleCancellation = handleCancellation;
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function handleCancellation(abortSignal) {
  return source$ => {
    const stop$ = new _rxjs.Subject();
    if (abortSignal.aborted) {
      stop$.next();
    }
    abortSignal.addEventListener('abort', () => {
      stop$.next();
    });
    return new _rxjs.Observable(subscriber => {
      return source$.pipe((0, _rxjs.takeUntil)(stop$)).subscribe({
        next: value => {
          subscriber.next(value);
        },
        error: err => {
          subscriber.error(err);
        },
        complete: () => {
          if (abortSignal.aborted) {
            subscriber.error((0, _inferenceCommon.createInferenceRequestAbortedError)());
          } else {
            subscriber.complete();
          }
        }
      });
    });
  };
}