"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallationVersionStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../../hooks");
var _use_installed_integrations_actions = require("../hooks/use_installed_integrations_actions");
var _disabled_wrapper_tooltip = require("./disabled_wrapper_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InstalledVersionStatus = /*#__PURE__*/_react.default.memo(({
  item
}) => {
  var _item$installationInf, _item$installationInf2;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "checkInCircleFilled",
    color: "success"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, (_item$installationInf = (_item$installationInf2 = item.installationInfo) === null || _item$installationInf2 === void 0 ? void 0 : _item$installationInf2.version) !== null && _item$installationInf !== void 0 ? _item$installationInf : item.version));
});
const UpgradeAvailableVersionStatus = /*#__PURE__*/_react.default.memo(({
  item
}) => {
  const authz = (0, _hooks.useAuthz)();
  const isDisabled = !authz.integrations.upgradePackages;
  const {
    actions: {
      bulkUpgradeIntegrationsWithConfirmModal
    }
  } = (0, _use_installed_integrations_actions.useInstalledIntegrationsActions)();
  return /*#__PURE__*/_react.default.createElement(_disabled_wrapper_tooltip.DisabledWrapperTooltip, {
    tooltipContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.upgradeRequiredPermissionTooltip",
      defaultMessage: "You don't have permissions to upgrade. Contact your administrator."
    }),
    disabled: isDisabled
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "gear",
    flush: "left",
    onClick: () => {
      bulkUpgradeIntegrationsWithConfirmModal([item]);
    },
    disabled: isDisabled
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.upgradeAvailableButton",
    defaultMessage: "Upgrade to {version}",
    values: {
      version: item.version
    }
  })));
});
const UpgradingVersionStatus = /*#__PURE__*/_react.default.memo(({
  item
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.upgradingTooltip",
      defaultMessage: 'Upgrading to {version}',
      values: {
        version: item.version
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: 'm'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.upgradingText",
    defaultMessage: "Upgrading..."
  }))));
});
const UninstallingVersionStatus = /*#__PURE__*/_react.default.memo(({
  item
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: 'm'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.uninstallingText",
    defaultMessage: "Uninstalling..."
  })));
});
function formatAttempt(attempt) {
  var _attempt$error, _attempt$error2;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packageCard.faileAttemptDescription",
    defaultMessage: "Failed at {attemptDate}.",
    values: {
      attemptDate: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: attempt.created_at,
        year: "numeric",
        month: "short",
        day: "numeric"
      }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " @ "), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: attempt.created_at,
        hour: "numeric",
        minute: "numeric",
        second: "numeric"
      }))
    }
  }), /*#__PURE__*/_react.default.createElement("p", null, ((_attempt$error = attempt.error) === null || _attempt$error === void 0 ? void 0 : _attempt$error.name) || '', " : ", ((_attempt$error2 = attempt.error) === null || _attempt$error2 === void 0 ? void 0 : _attempt$error2.message) || ''));
}
const InstallUpgradeFailedVersionStatus = /*#__PURE__*/_react.default.memo(({
  item,
  isUpgradeFailed
}) => {
  var _item$installationInf3, _item$installationInf4;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  //  TODO handle failed install too
  // TODO permissions check and tooltip

  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "left",
    onClick: () => setIsPopoverOpen(currentVal => !currentVal)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "error",
    color: "danger"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isUpgradeFailed ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.statusUpgradeFailedLabel",
    defaultMessage: "Upgrade failed"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.statusInstallFailedLabel",
    defaultMessage: "Install failed"
  }))));
  const latestAttempt = (_item$installationInf3 = item.installationInfo) === null || _item$installationInf3 === void 0 ? void 0 : (_item$installationInf4 = _item$installationInf3.latest_install_failed_attempts) === null || _item$installationInf4 === void 0 ? void 0 : _item$installationInf4[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    css: {
      maxWidth: 400
    },
    color: "danger",
    title: isUpgradeFailed ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.statusUpgradeFailedLabel",
      defaultMessage: "Upgrade to {version } failed",
      values: {
        version: latestAttempt === null || latestAttempt === void 0 ? void 0 : latestAttempt.target_version
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epmInstalledIntegrations.statusInstallFailedLabel",
      defaultMessage: "Install failed"
    })
  }, latestAttempt ? formatAttempt(latestAttempt) : null, isUpgradeFailed &&
  /*#__PURE__*/
  // TODO Implement on click https://github.com/elastic/kibana/issues/209867
  _react.default.createElement(_eui.EuiButton, {
    color: "danger",
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epmInstalledIntegrations.retryUpgradeButtonLabel",
    defaultMessage: "Retry Upgrade"
  }))));
});
const InstallationVersionStatus = exports.InstallationVersionStatus = /*#__PURE__*/_react.default.memo(({
  item
}) => {
  const status = item.ui.installation_status;
  if (status === 'installed') {
    return /*#__PURE__*/_react.default.createElement(InstalledVersionStatus, {
      item: item
    });
  } else if (status === 'upgrade_available') {
    return /*#__PURE__*/_react.default.createElement(UpgradeAvailableVersionStatus, {
      item: item
    });
  } else if (status === 'upgrading') {
    return /*#__PURE__*/_react.default.createElement(UpgradingVersionStatus, {
      item: item
    });
  } else if (status === 'uninstalling') {
    return /*#__PURE__*/_react.default.createElement(UninstallingVersionStatus, {
      item: item
    });
  } else if (status === 'upgrade_failed') {
    return /*#__PURE__*/_react.default.createElement(InstallUpgradeFailedVersionStatus, {
      isUpgradeFailed: true,
      item: item
    });
  } else if (status === 'install_failed') {
    return /*#__PURE__*/_react.default.createElement(InstallUpgradeFailedVersionStatus, {
      isUpgradeFailed: false,
      item: item
    });
  } else return null;
});