"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutputFormKafkaCompression = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OutputFormKafkaCompression = props => {
  const {
    inputs
  } = props;
  const kafkaCompressionTypeOptions = (0, _react.useMemo)(() => Object.keys(_constants.kafkaCompressionType).filter(c => c !== 'None').map(key => ({
    text: _constants.kafkaCompressionType[key],
    label: _constants.kafkaCompressionType[key]
  })), []);
  const kafkaCompressionLevelOptions = (0, _react.useMemo)(() => Array.from({
    length: 9
  }, (_, i) => i + 1).map(level => ({
    text: level,
    label: level.toString()
  })), []);
  const renderCompression = () => {
    if (!inputs.kafkaCompressionInput.value) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.editOutputFlyout.kafkaCompressionCodecInputLabel",
        defaultMessage: "Codec"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
      fullWidth: true,
      "data-test-subj": "settingsOutputsFlyout.kafkaCompressionCodecInput"
    }, inputs.kafkaCompressionCodecInput.props, {
      options: kafkaCompressionTypeOptions
    }))), inputs.kafkaCompressionCodecInput.value === _constants.kafkaCompressionType.Gzip && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.editOutputFlyout.kafkaCompressionLevelInputLabel",
        defaultMessage: "Level"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
      fullWidth: true
    }, inputs.kafkaCompressionLevelInput.props, {
      "data-test-subj": "settingsOutputsFlyout.kafkaCompressionLevelInput",
      options: kafkaCompressionLevelOptions
    }))));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    hasShadow: false,
    paddingSize: 'm',
    color: 'subdued',
    "data-test-subj": "settingsOutputsFlyout.kafkaCompressionPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "FleetEditOutputFlyoutKafkaCompression"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.editOutputFlyout.kafkaCompressionTitle",
    defaultMessage: "Compression"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": 'settingsOutputsFlyout.kafkaCompressionSwitch'
  }, inputs.kafkaCompressionInput.props, {
    onChange: e => {
      if (!e.target.checked) {
        // Reset compression codec, if compression is disabled. In Api there is no compression state, only codec and level.
        inputs.kafkaCompressionCodecInput.setValue(_constants.kafkaCompressionType.None);
      }
      inputs.kafkaCompressionInput.setValue(e.target.checked);
    },
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.editOutputFlyout.kafkaCompressionSwitchLabel",
      defaultMessage: "Enable compression"
    })
  })), renderCompression());
};
exports.OutputFormKafkaCompression = OutputFormKafkaCompression;