"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentHealth = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _agent_status = require("../../../../../../common/services/agent_status");
var _hooks = require("../../../hooks");
var _hooks2 = require("../agent_details_page/hooks");
var _agent_upgrade_modal = require("./agent_upgrade_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getStatusComponent({
  status,
  upgradeDetails,
  ...restOfProps
}) {
  switch (status) {
    case 'error':
    case 'degraded':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "warning"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.unhealthyStatusText",
        defaultMessage: "Unhealthy"
      }));
    case 'inactive':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: _uiTheme.euiLightVars.euiColorDarkShade
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.inactiveStatusText",
        defaultMessage: "Inactive"
      }));
    case 'offline':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "default"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.offlineStatusText",
        defaultMessage: "Offline"
      }));
    case 'uninstalled':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "default"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.uninstalledStatusText",
        defaultMessage: "Uninstalled"
      }));
    case 'orphaned':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "warning"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.orphanedStatusText",
        defaultMessage: "Orphaned"
      }));
    case 'unenrolling':
    case 'enrolling':
    case 'updating':
      return (0, _agent_status.isAgentInFailedUpgradeState)(upgradeDetails) ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "danger"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.upgradingFailedStatusText",
        defaultMessage: "Upgrade failed"
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "primary"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.updatingStatusText",
        defaultMessage: "Updating"
      }));
    case 'unenrolled':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: _uiTheme.euiLightVars.euiColorDisabled
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.unenrolledStatusText",
        defaultMessage: "Unenrolled"
      }));
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: "success"
      }, restOfProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.healthyStatusText",
        defaultMessage: "Healthy"
      }));
  }
}
const WrappedEuiCallOut = (0, _styledComponents.default)(_eui.EuiCallOut)`
  white-space: wrap !important;
`;
const AgentHealth = ({
  agent,
  fromDetails,
  ...restOfProps
}) => {
  const {
    last_checkin: lastCheckIn,
    last_checkin_message: lastCheckInMessage
  } = agent;
  const msLastCheckIn = new Date(lastCheckIn || 0).getTime();
  const lastCheckInMessageText = lastCheckInMessage ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.checkinMessageText",
    defaultMessage: "Last checkin message: {lastCheckinMessage}",
    values: {
      lastCheckinMessage: lastCheckInMessage
    }
  }) : null;
  const lastCheckinText = msLastCheckIn ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.checkInTooltipText",
    defaultMessage: "Last checked in {lastCheckIn}",
    values: {
      lastCheckIn: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        value: msLastCheckIn
      })
    }
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.noCheckInTooltipText",
    defaultMessage: "Never checked in"
  });
  const previousToOfflineStatus = (0, _react.useMemo)(() => {
    if (!fromDetails || agent.status !== 'offline') {
      return;
    }
    return (0, _agent_status.getPreviousAgentStatusForOfflineAgents)(agent);
  }, [fromDetails, agent]);
  const [isUpgradeModalOpen, setIsUpgradeModalOpen] = (0, _react.useState)(false);
  const refreshAgent = (0, _hooks2.useAgentRefresh)();
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, lastCheckinText), /*#__PURE__*/_react.default.createElement("p", null, lastCheckInMessageText), (0, _agent_status.isStuckInUpdating)(agent) ? (0, _agent_status.isAgentInFailedUpgradeState)(agent.upgrade_details) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.failedUpgradeTooltipText",
      defaultMessage: "Agent upgrade failed. Consider restarting the upgrade."
    }) : /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.restartUpgradeTooltipText",
      defaultMessage: "Agent may be stuck updating. Consider restarting the upgrade."
    })) : null)
  }, (0, _agent_status.isStuckInUpdating)(agent) && !fromDetails ? /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textNoWrap"
  }, getStatusComponent({
    status: agent.status,
    upgradeDetails: agent.upgrade_details,
    ...restOfProps
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getStatusComponent({
    status: agent.status,
    upgradeDetails: agent.upgrade_details,
    ...restOfProps
  }), previousToOfflineStatus ? getStatusComponent({
    status: previousToOfflineStatus,
    ...restOfProps
  }) : null)), fromDetails && (0, _agent_status.isStuckInUpdating)(agent) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(WrappedEuiCallOut, {
    iconType: "warning",
    size: "m",
    color: "warning",
    title: (0, _agent_status.isAgentInFailedUpgradeState)(agent.upgrade_details) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.failedUpgradeTitle",
      defaultMessage: "Agent upgrade is stuck in failed state."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentHealth.stuckUpdatingTitle",
      defaultMessage: "Agent may be stuck updating."
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.stuckUpdatingText",
    defaultMessage: "{stuckMessage} Consider restarting the upgrade. {learnMore}",
    values: {
      stuckMessage: (0, _agent_status.isAgentInFailedUpgradeState)(agent.upgrade_details) ? 'Agent upgrade failed.' : 'Agent has been updating for a while, and may be stuck.',
      learnMore: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.upgradeElasticAgent,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentHealth.upgradeAgentsDocLink",
        defaultMessage: "Learn more"
      })))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    onClick: () => {
      setIsUpgradeModalOpen(true);
    },
    "data-test-subj": "restartUpgradeBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentHealth.restartUpgradeBtn",
    defaultMessage: "Restart upgrade"
  })))) : null, isUpgradeModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_upgrade_modal.AgentUpgradeAgentModal, {
    agents: [agent],
    agentCount: 1,
    onClose: () => {
      setIsUpgradeModalOpen(false);
      refreshAgent();
    },
    isUpdating: true
  })));
};
exports.AgentHealth = AgentHealth;