"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.previewTikaContents = previewTikaContents;
var _fileUploadCommon = require("@kbn/file-upload-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the contents of a file using the attachment ingest processor
 * @param client IScopedClusterClient
 * @param base64File bae64 encoded file
 */
async function previewTikaContents(client, base64File) {
  var _resp$docs$0$doc, _resp$docs$0$doc2;
  const pipeline = {
    description: '',
    processors: [{
      attachment: {
        field: 'data',
        remove_binary: true,
        indexed_chars: _fileUploadCommon.TIKA_PREVIEW_CHARS
      }
    }]
  };
  const resp = await client.asInternalUser.ingest.simulate({
    pipeline,
    docs: [{
      _index: 'index',
      _id: 'id',
      _source: {
        data: base64File
      }
    }]
  });
  if (!((_resp$docs$0$doc = resp.docs[0].doc) !== null && _resp$docs$0$doc !== void 0 && _resp$docs$0$doc._source.attachment)) {
    throw new Error('Failed to extract text from file.');
  }
  return (_resp$docs$0$doc2 = resp.docs[0].doc) === null || _resp$docs$0$doc2 === void 0 ? void 0 : _resp$docs$0$doc2._source.attachment;
}