"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCombinedDefendInsightsPrompt = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// NOTE: we ask the LLM to `provide insights`. We do NOT use the feature name, `DefendInsights`, in the prompt.
const getEventsContextPrompt = ({
  anonymizedEvents,
  defendInsightsPrompt
}) => `${defendInsightsPrompt}

Use context from the following events to provide insights:

"""
${anonymizedEvents.join('\n\n')}
"""
`;

/**
 * Returns the the initial query, or the initial query combined with a
 * continuation prompt and partial results
 */
const getCombinedDefendInsightsPrompt = ({
  anonymizedDocs,
  prompt,
  combinedMaybePartialResults,
  continuePrompt
}) => {
  const eventsContextPrompt = getEventsContextPrompt({
    anonymizedEvents: anonymizedDocs,
    defendInsightsPrompt: prompt
  });
  return (0, _fp.isEmpty)(combinedMaybePartialResults) ? eventsContextPrompt // no partial results yet
  : `${eventsContextPrompt}

${continuePrompt}

"""
${combinedMaybePartialResults}
"""

`;
};
exports.getCombinedDefendInsightsPrompt = getCombinedDefendInsightsPrompt;