"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQuery = getQuery;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _file_events = require("./file_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getQuery(type, options) {
  if (type === _elasticAssistantCommon.DefendInsightType.Enum.incompatible_antivirus) {
    const {
      endpointIds,
      size,
      gte,
      lte
    } = options;
    return (0, _file_events.getFileEventsQuery)({
      endpointIds,
      size,
      gte,
      lte
    });
  }
  throw new Error('Invalid defend insight type');
}