"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPaddedAlertTimeRange = exports.generateContext = void 0;
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/stack-alerts-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPaddedAlertTimeRange = (alertStart, alertEnd, lookBackWindow) => {
  const alertDuration = _moment.default.duration((0, _moment.default)(alertEnd).diff((0, _moment.default)(alertStart)));
  const now = (0, _moment.default)().toISOString();

  // If alert duration is less than 160 min, we use 20 minute buffer
  // Otherwise, we use 8 times alert duration
  const defaultDurationMs = alertDuration.asMinutes() < 160 ? _moment.default.duration(20, 'minutes').asMilliseconds() : alertDuration.asMilliseconds() / 8;
  // To ensure the alert time range at least covers 20 times lookback window,
  // we compare lookBackDurationMs and defaultDurationMs to use any of those that is longer
  const lookBackDurationMs = lookBackWindow && _moment.default.duration(lookBackWindow.size * 20, lookBackWindow.unit).asMilliseconds();
  const durationMs = lookBackDurationMs && lookBackDurationMs - defaultDurationMs > 0 ? lookBackDurationMs : defaultDurationMs;
  const from = (0, _moment.default)(alertStart).subtract(durationMs, 'millisecond').toISOString();
  const to = alertEnd && (0, _moment.default)(alertEnd).add(durationMs, 'millisecond').isBefore(now) ? (0, _moment.default)(alertEnd).add(durationMs, 'millisecond').toISOString() : now;
  return {
    from,
    to,
    refresh: {
      pause: true,
      value: 60000
    }
  };
};
exports.getPaddedAlertTimeRange = getPaddedAlertTimeRange;
const getDataQualityViewInAppUrl = ({
  index,
  from,
  to,
  locatorsClient
}) => {
  var _locatorsClient$get2;
  const timeRange = getPaddedAlertTimeRange(from, to);
  timeRange.to = to ? timeRange.to : 'now';

  // If index is a wildcard or multiple indices, redirect to the data quality overview page
  if (index.includes('*') || index.includes(',')) {
    var _locatorsClient$get;
    return locatorsClient === null || locatorsClient === void 0 ? void 0 : (_locatorsClient$get = locatorsClient.get(_deeplinksObservability.DATA_QUALITY_LOCATOR_ID)) === null || _locatorsClient$get === void 0 ? void 0 : _locatorsClient$get.getRedirectUrl({
      timeRange: {
        from,
        to,
        refresh: {
          pause: true,
          value: 60000
        }
      }
    });
  }
  return locatorsClient === null || locatorsClient === void 0 ? void 0 : (_locatorsClient$get2 = locatorsClient.get(_deeplinksObservability.DATA_QUALITY_DETAILS_LOCATOR_ID)) === null || _locatorsClient$get2 === void 0 ? void 0 : _locatorsClient$get2.getRedirectUrl({
    dataStream: index,
    timeRange: {
      from,
      to,
      refresh: {
        pause: true,
        value: 60000
      }
    }
  });
};
const generateReason = (value, group, timeSize, timeUnit, comparator, threshold) => _i18n.i18n.translate('xpack.datasetQuality.rule.alertTypeContextReasonDescription', {
  defaultMessage: `Percentage of degraded documents is {value}% in the last {window} for {group}. Alert when {comparator} {threshold}%.`,
  values: {
    value,
    window: `${timeSize}${timeUnit}`,
    group,
    comparator: (0, _common.getHumanReadableComparator)(comparator),
    threshold: threshold.join(' and ')
  }
});
const generateContext = ({
  group,
  dateStart,
  dateEnd,
  value,
  params,
  grouping,
  locatorsClient
}) => ({
  value,
  reason: generateReason(value, group, params.timeSize, params.timeUnit, params.comparator, params.threshold),
  grouping,
  timestamp: dateEnd,
  viewInAppUrl: getDataQualityViewInAppUrl({
    index: params.searchConfiguration.index,
    from: dateStart,
    to: dateEnd,
    locatorsClient
  })
});
exports.generateContext = generateContext;