"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataPlaceholder = DataPlaceholder;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("../../common");
var _translations = require("../../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DataPlaceholder({
  title,
  tooltip,
  value,
  isLoading,
  isUserAuthorizedForDataset
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tooltip
  })), /*#__PURE__*/_react.default.createElement(_common.PrivilegesWarningIconWrapper, {
    hasPrivileges: isUserAuthorizedForDataset,
    title: title,
    mode: "popover",
    popoverCss: {
      marginLeft: 'auto'
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null))), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "m",
    "data-test-subj": `datasetQuality-${title}-loading`
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": `datasetQualityDatasetHealthKpi-${title}`,
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isUserAuthorizedForDataset ? value : _translations.notAvailableLabel))));
}