"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternRequestFlyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _auto_follow_pattern_serialization = require("../../../common/services/auto_follow_pattern_serialization");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AutoFollowPatternRequestFlyout extends _react.PureComponent {
  render() {
    const {
      name,
      autoFollowPattern,
      close,
      isNew
    } = this.props;
    const endpoint = `PUT /_ccr/auto_follow/${name ? name : '<autoFollowPatternName>'}`;
    const payload = JSON.stringify((0, _auto_follow_pattern_serialization.serializeAutoFollowPattern)(autoFollowPattern), null, 2);
    const request = `${endpoint}\n${payload}`;
    const modalTitleId = (0, _eui.htmlIdGenerator)()('autoFollowPatternRequestFlyoutTitle');
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      maxWidth: 480,
      onClose: close,
      "aria-labelledby": modalTitleId
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
      id: modalTitleId
    }, name ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternForm.requestFlyout.namedTitle",
      defaultMessage: "Request for ''{name}''",
      values: {
        name
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternForm.requestFlyout.unnamedTitle",
      defaultMessage: "Request"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, isNew ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternForm.requestFlyout.createDescriptionText",
      defaultMessage: "This Elasticsearch request will create this auto-follow pattern."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternForm.requestFlyout.editDescriptionText",
      defaultMessage: "This Elasticsearch request will update this auto-follow pattern."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true
    }, request)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      onClick: close,
      flush: "left"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.autoFollowPatternForm.requestFlyout.closeButtonLabel",
      defaultMessage: "Close"
    }))));
  }
}
exports.AutoFollowPatternRequestFlyout = AutoFollowPatternRequestFlyout;
(0, _defineProperty2.default)(AutoFollowPatternRequestFlyout, "propTypes", {
  close: _propTypes.default.func.isRequired,
  name: _propTypes.default.string.isRequired,
  autoFollowPattern: _propTypes.default.object.isRequired,
  isNew: _propTypes.default.bool
});