/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.cases_bundle_jsonpfunction=self.cases_bundle_jsonpfunction||[]).push([[431],{2431:(e,t,a)=>{a.r(t),a.d(t,{FileUpload:()=>P,default:()=>z});var i=a(4286),l=a.n(i),s=a(9673),o=a(6791),r=a(7880),n=a(1319);function d(e){return(0,r.A)(e,e.getValue())}const u=l().createContext(null),c=()=>l().useContext(u);var p=a(5008);const h={defaultPickerLabel:p.i18n.translate("sharedUXPackages.fileUpload.defaultFilePickerLabel",{defaultMessage:"Upload a file"}),fileEmpty:p.i18n.translate("sharedUXPackages.fileUpload.fileEmptyErrorMessage",{defaultMessage:"File is empty. Please provide a file with content."}),upload:p.i18n.translate("sharedUXPackages.fileUpload.uploadButtonLabel",{defaultMessage:"Upload"}),uploading:p.i18n.translate("sharedUXPackages.fileUpload.uploadingButtonLabel",{defaultMessage:"Uploading"}),uploadComplete:p.i18n.translate("sharedUXPackages.fileUpload.uploadCompleteButtonLabel",{defaultMessage:"Upload complete"}),retry:p.i18n.translate("sharedUXPackages.fileUpload.retryButtonLabel",{defaultMessage:"Retry"}),clear:p.i18n.translate("sharedUXPackages.fileUpload.clearButtonLabel",{defaultMessage:"Clear"}),cancel:p.i18n.translate("sharedUXPackages.fileUpload.cancelButtonLabel",{defaultMessage:"Cancel"}),uploadDone:p.i18n.translate("sharedUXPackages.fileUpload.uploadDoneToolTipContent",{defaultMessage:"Your file was successfully uploaded!"}),fileTooLarge:e=>p.i18n.translate("sharedUXPackages.fileUpload.fileTooLargeErrorMessage",{defaultMessage:"File is too large. Maximum size is {expectedSize, plural, one {# byte} other {# bytes} }.",values:{expectedSize:e}}),mimeTypeNotSupported:(e,t)=>p.i18n.translate("sharedUXPackages.fileUpload.mimeTypeNotSupportedErrorMessage",{defaultMessage:'File mime type "{mimeType}" is not supported. Supported mime types are: {supportedMimeTypes}.',values:{mimeType:e,supportedMimeTypes:t}})},f=({onClick:e})=>{const t=c(),a=d(t.uploading$),i=d(t.error$),l=(0,r.A)(t.done$),s=(0,r.A)(t.files$,[]);return(0,o.jsx)(n.EuiButton,{key:"uploadButton",isLoading:a,color:l?"success":"primary",fill:!0,iconType:l?"checkInCircleFilled":void 0,disabled:Boolean(!s.length||i||l),onClick:e,size:"s","data-test-subj":"uploadButton"},l?h.uploadComplete:a?h.uploading:h.upload)},m=({onClick:e})=>{const t=d(c().uploading$);return(0,o.jsx)(n.EuiButton,{key:"retryButton",size:"s","data-test-subj":"retryButton",disabled:t,onClick:e},h.retry)},g=({onClick:e,compressed:t})=>{const a=!d(c().uploading$);return t?(0,o.jsx)(n.EuiButtonIcon,{color:"danger","data-test-subj":"cancelButtonIcon",disabled:a,iconType:"cross","aria-label":h.cancel,onClick:e}):(0,o.jsx)(n.EuiButton,{color:"danger",fill:!0,key:"cancelButton",size:"s","data-test-subj":"cancelButton",disabled:a,onClick:e},h.cancel)},b=({onCancel:e,onUpload:t,immediate:a,compressed:i})=>{const l=c(),s=d(l.uploading$),n=(0,r.A)(l.files$,[]),u=Boolean(n.some((e=>"upload_failed"===e.status)));return i||s?(0,o.jsx)(g,{compressed:i,onClick:e}):u?(0,o.jsx)(m,{onClick:t}):a?null:(0,o.jsx)(f,{onClick:t})},w=({onClick:e})=>(0,o.jsx)(n.EuiButtonEmpty,{size:"s","data-test-subj":"clearButton",onClick:e,color:"primary"},h.clear),x={horizontalContainer:{name:"ho1qnd",styles:"display:flex;flex-direction:row"},fullWidth:{name:"1d3w5wq",styles:"width:100%"}},M=l().forwardRef((({compressed:e,meta:t,accept:a,immediate:i,allowClear:s=!1,multiple:u,initialFilePromptText:p,fullWidth:f,className:m},g)=>{const{euiTheme:M}=(0,n.useEuiTheme)(),v=c(),y=d(v.uploading$),U=d(v.error$),j=(0,r.A)(v.done$),$=Boolean(U),S=null==U?void 0:U.message,E=(0,n.useGeneratedHtmlId)({prefix:"filesFileUpload"}),k=`${E}_error`;return(0,o.jsx)("div",{"data-test-subj":"filesFileUpload",css:[(0,o.css)("max-width:",f?"100%":M.components.forms.maxWidth,";",""),f?x.fullWidth:void 0,e?x.horizontalContainer:void 0,"",""],className:m},(0,o.jsx)(n.EuiFilePicker,{fullWidth:f,"aria-label":h.defaultPickerLabel,id:E,ref:g,onChange:e=>{v.setFiles(Array.from(null!=e?e:[])),i&&v.hasFiles()&&v.upload(t)},multiple:u,initialPromptText:p,isLoading:y,isInvalid:$,accept:a,disabled:Boolean((null==j?void 0:j.length)||y),"aria-describedby":S?k:void 0,display:e?"default":"large"}),(0,o.jsx)(n.EuiSpacer,{size:"s",css:e?(0,o.css)("width:",M.size.s,";",""):void 0}),(0,o.jsx)(n.EuiFlexGroup,{justifyContent:"flexStart",alignItems:e?"center":"flexStart",direction:e?void 0:"rowReverse",gutterSize:e?"none":"m",responsive:!1},(0,o.jsx)(n.EuiFlexItem,{grow:!1},(0,o.jsx)(b,{compressed:e,immediate:i,onCancel:v.abort,onUpload:()=>v.upload(t)})),!e&&Boolean(!j&&!y&&S)&&(0,o.jsx)(n.EuiFlexItem,null,(0,o.jsx)(n.EuiText,{"data-test-subj":"error",css:(0,o.css)("display:flex;align-items:center;min-height:",M.size.xl,";",""),size:"s",color:"danger"},(0,o.jsx)("span",{id:k},S))),!e&&(null==j?void 0:j.length)&&s&&(0,o.jsx)(l().Fragment,null,(0,o.jsx)(n.EuiFlexItem,null)," ",(0,o.jsx)(n.EuiFlexItem,{grow:!1},(0,o.jsx)(w,{onClick:v.clear})))))}));var v=a(8915),y=a(190),U=["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","#","$","%","*","+",",","-",".",":",";","=","?","@","[","]","^","_","{","|","}","~"],j=(e,t)=>{var a="";for(let i=1;i<=t;i++){let l=Math.floor(e)/Math.pow(83,t-i)%83;a+=U[Math.floor(l)]}return a},$=e=>{let t=e/255;return t<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)},S=e=>{let t=Math.max(0,Math.min(1,e));return t<=.0031308?Math.trunc(12.92*t*255+.5):Math.trunc(255*(1.055*Math.pow(t,.4166666666666667)-.055)+.5)},E=(e,t)=>(e=>e<0?-1:1)(e)*Math.pow(Math.abs(e),t),k=class extends Error{constructor(e){super(e),this.name="ValidationError",this.message=e}},B=(e,t,a,i)=>{let l=0,s=0,o=0,r=4*t;for(let n=0;n<t;n++){let t=4*n;for(let d=0;d<a;d++){let a=t+d*r,u=i(n,d);l+=u*$(e[a]),s+=u*$(e[a+1]),o+=u*$(e[a+2])}}let n=1/(t*a);return[l*n,s*n,o*n]},C=(e,t,a,i,l)=>{if(i<1||i>9||l<1||l>9)throw new k("BlurHash must have between 1 and 9 components");if(t*a*4!==e.length)throw new k("Width and height must match the pixels array");let s=[];for(let o=0;o<l;o++)for(let l=0;l<i;l++){let i=0==l&&0==o?1:2,r=B(e,t,a,((e,s)=>i*Math.cos(Math.PI*l*e/t)*Math.cos(Math.PI*o*s/a)));s.push(r)}let o,r=s[0],n=s.slice(1),d="";if(d+=j(i-1+9*(l-1),1),n.length>0){let e=Math.max(...n.map((e=>Math.max(...e)))),t=Math.floor(Math.max(0,Math.min(82,Math.floor(166*e-.5))));o=(t+1)/166,d+=j(t,1)}else o=1,d+=j(0,1);return d+=j((e=>(S(e[0])<<16)+(S(e[1])<<8)+S(e[2]))(r),4),n.forEach((e=>{d+=j(((e,t)=>19*Math.floor(Math.max(0,Math.min(18,Math.floor(9*E(e[0]/t,.5)+9.5))))*19+19*Math.floor(Math.max(0,Math.min(18,Math.floor(9*E(e[1]/t,.5)+9.5))))+Math.floor(Math.max(0,Math.min(18,Math.floor(9*E(e[2]/t,.5)+9.5)))))(e,o),2)})),d};async function F(e){const t=window.URL.createObjectURL(e);try{const e=await function(e){return new Promise(((t,a)=>{const i=new window.Image;i.src=e,i.onload=()=>t(i),i.onerror=a}))}(t),a=document.createElement("canvas"),{width:i,height:l}=function(e,t){const a=Math.abs(Math.min(Math.min(120/e,120/t),1)-1);return{width:Math.floor(e-a*e),height:Math.floor(t-a*t)}}(e.width,e.height);a.width=i,a.height=l;const s=a.getContext("2d");if(!s)throw new Error("Could not get 2d canvas context!");s.drawImage(e,0,0,i,l);const o=s.getImageData(0,0,i,l);return{blurhash:C(o.data,o.width,o.height,4,4),width:e.width,height:e.height}}catch(e){return}finally{window.URL.revokeObjectURL(t)}}var T=a(770);class SimpleStateSubject extends y.BehaviorSubject{constructor(e){super(e)}getSnapshot(){return this.getValue()}setState(e){this.next((0,T.merge)({},this.getSnapshot(),e))}}class UploadState{constructor(e,t,a={allowRepeatedUploads:!1},i=F){(0,v.default)(this,"abort$",new y.Subject),(0,v.default)(this,"files$$",new y.BehaviorSubject([])),(0,v.default)(this,"files$",this.files$$.pipe(y.switchMap((e=>e.length?y.zip(...e):y.of([]))))),(0,v.default)(this,"clear$",new y.Subject),(0,v.default)(this,"error$",new y.BehaviorSubject(void 0)),(0,v.default)(this,"uploading$",new y.BehaviorSubject(!1)),(0,v.default)(this,"done$",new y.Subject),(0,v.default)(this,"subscriptions",void 0),(0,v.default)(this,"validateFile",(e=>{const t=this.fileKind;if(!e.size)throw new Error(h.fileEmpty);if(null!=t.maxSizeBytes&&e.size>this.fileKind.maxSizeBytes){const e=h.fileTooLarge(String(this.fileKind.maxSizeBytes));throw new Error(e)}if(null!=t.allowedMimeTypes&&!t.allowedMimeTypes.includes(e.type)){const a=h.mimeTypeNotSupported(e.type,t.allowedMimeTypes.join(", "));throw new Error(a)}})),(0,v.default)(this,"setFiles",(e=>{if(this.isUploading())throw new Error("Cannot update files while uploading");let t;e.length||(this.done$.next(void 0),this.error$.next(void 0));try{e.forEach(this.validateFile)}catch(e){t=e}this.files$$.next(e.map((e=>new SimpleStateSubject({file:e,status:"idle",error:t}))))})),(0,v.default)(this,"abort",(()=>{if(!this.isUploading())throw new Error("No upload in progress");this.abort$.next()})),(0,v.default)(this,"clear",(()=>{this.setFiles([]),this.clear$.next()})),(0,v.default)(this,"uploadFile",((e,t,a)=>{const i=new AbortController,l=i.signal,{file:s,status:o,error:r}=e.getValue();if(r&&"idle"===o)return y.of(void 0);if(!["idle","upload_failed"].includes(o))return y.of(void 0);let n;e.setState({status:"uploading",error:void 0});const{name:d}={name:((u=s.name).substring(0,u.lastIndexOf("."))||u).trim().slice(0,256)};var u;const c=s.type||void 0,p=a;return y.from(function(e){var t;return Boolean(null===(t=e.type)||void 0===t?void 0:t.startsWith("image/"))}(s)?this.loadImageMetadata(s):y.of(void 0)).pipe(y.mergeMap((e=>this.client.create({kind:this.fileKind.id,name:d,mimeType:c,meta:e?{...e,...p}:p}))),y.mergeMap((e=>(n=e.file,y.race(t.pipe(y.map((()=>{throw i.abort(),new Error("Abort!")}))),this.client.upload({body:s,id:n.id,kind:this.fileKind.id,abortSignal:l,selfDestructOnAbort:!0,contentType:c}))))),y.map((()=>{var t;e.setState({status:"uploaded",id:null===(t=n)||void 0===t?void 0:t.id,fileJSON:n})})),y.catchError((t=>{const a="Abort!"===t.message;return e.setState({status:"upload_failed",error:a?void 0:t}),y.of(a?void 0:t)})))})),(0,v.default)(this,"upload",(e=>{if(this.isUploading())throw new Error("Upload already in progress");const t=new y.ReplaySubject(1),a=this.abort$.subscribe(t),i=this.files$$.pipe(y.take(1),y.switchMap((a=>y.forkJoin(a.map((a=>this.uploadFile(a,t,e)))))),y.map((()=>{})),y.finalize((()=>{this.opts.allowRepeatedUploads&&this.clear(),a.unsubscribe()})),y.shareReplay());return i.subscribe(),i})),(0,v.default)(this,"dispose",(()=>{for(const e of this.subscriptions)e.unsubscribe()})),this.fileKind=e,this.client=t,this.opts=a,this.loadImageMetadata=i;const l=this.files$$.pipe(y.switchMap((e=>y.combineLatest(e))));this.subscriptions=[l.pipe(y.map((e=>e.some((e=>"uploading"===e.status)))),y.distinctUntilChanged()).subscribe(this.uploading$),l.pipe(y.map((e=>{const t=e.find((e=>Boolean(e.error)));return t?t.error:void 0})),y.filter(Boolean)).subscribe(this.error$),l.pipe(y.filter((e=>Boolean(e.length)&&e.every((e=>"uploaded"===e.status)))),y.map((e=>e.map((e=>({id:e.id,kind:this.fileKind.id,fileJSON:e.fileJSON})))))).subscribe(this.done$)]}isUploading(){return this.uploading$.getValue()}hasFiles(){return this.files$$.getValue().length>0}}const P=({meta:e,onDone:t,onError:a,fullWidth:l,allowClear:r,onUploadEnd:n,onUploadStart:d,compressed:c=!1,kind:p,multiple:h=!1,initialPromptText:f,immediate:m=!1,allowRepeatedUploads:g=!1,className:b})=>{var w;const{client:x}=(0,s.A)(),v=(0,i.useRef)(null),y=x.getFileKind(p),U=c||g,j=(0,i.useMemo)((()=>(({fileKind:e,client:t,imageMetadataFactory:a,...i})=>new UploadState(e,t,i,a))({client:x,fileKind:y,allowRepeatedUploads:U})),[x,U,y]);return(0,i.useEffect)((()=>{const e=[j.clear$.subscribe((()=>{var e;null===(e=v.current)||void 0===e||e.removeFiles()})),j.done$.subscribe((e=>e&&t(e))),j.error$.subscribe((e=>e&&(null==a?void 0:a(e)))),j.uploading$.subscribe((e=>e?null==d?void 0:d():null==n?void 0:n()))];return()=>e.forEach((e=>e.unsubscribe()))}),[j,t,a,d,n]),(0,i.useEffect)((()=>j.dispose),[j]),(0,o.jsx)(u.Provider,{value:j},(0,o.jsx)(M,{compressed:c,ref:v,accept:null===(w=y.allowedMimeTypes)||void 0===w?void 0:w.join(","),meta:e,immediate:c||m,allowClear:r,fullWidth:l,initialFilePromptText:f,multiple:h,className:b}))},z=P}}]);