"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStats = void 0;
var _api = require("../../../common/types/api");
var _runtime_types = require("../../common/runtime_types");
var _error = require("../../common/error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStats = async ({
  caseId
}, casesClient, clientArgs) => {
  const {
    services: {
      userActionService
    },
    logger
  } = clientArgs;
  try {
    await casesClient.cases.resolve({
      id: caseId,
      includeComments: false
    });
    const totals = await userActionService.getCaseUserActionStats({
      caseId
    });
    return (0, _runtime_types.decodeOrThrow)(_api.CaseUserActionStatsResponseRt)(totals);
  } catch (error) {
    throw (0, _error.createCaseError)({
      message: `Failed to retrieve user action stats for case id: ${caseId}: ${error}`,
      error,
      logger
    });
  }
};
exports.getStats = getStats;