"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cx = exports.css = exports.cache = void 0;
var _createInstance = _interopRequireDefault(require("@emotion/css/create-instance"));
var _prefixer = require("./prefixer");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This custom instance is needed for internal EUI components to call
 * `@emotion/css` with EUI's custom prefixer plugin
 * @see https://emotion.sh/docs/@emotion/css#custom-instances
 *
 * NOTE: Usage is currently being beta tested internally,
 * and is not yet intended to be a public export
 */
var _createEmotion = (0, _createInstance.default)({
    key: 'css',
    stylisPlugins: [_prefixer.euiStylisPrefixer],
    speedy: false
  }),
  css = exports.css = _createEmotion.css,
  cx = exports.cx = _createEmotion.cx,
  cache = exports.cache = _createEmotion.cache;