/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

public enum Platform {
    LINUX,
    MACOS,
    WINDOWS;

    private static final Platform current;

    private static Platform findCurrent() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Linux")) {
            return LINUX;
        }
        if (os.startsWith("Mac OS")) {
            return MACOS;
        }
        if (os.startsWith("Windows")) {
            return WINDOWS;
        }
        throw new AssertionError((Object)("Unsupported platform [" + os + "]"));
    }

    public boolean isCurrent() {
        return this == current;
    }

    static {
        current = Platform.findCurrent();
    }
}

