/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.ip;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.IpPrefix;

public final class IpPrefixEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IpPrefixEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator ip;
    private final EvalOperator.ExpressionEvaluator prefixLengthV4;
    private final EvalOperator.ExpressionEvaluator prefixLengthV6;
    private final BytesRef scratch;
    private final DriverContext driverContext;
    private Warnings warnings;

    public IpPrefixEvaluator(Source source, EvalOperator.ExpressionEvaluator ip, EvalOperator.ExpressionEvaluator prefixLengthV4, EvalOperator.ExpressionEvaluator prefixLengthV6, BytesRef scratch, DriverContext driverContext) {
        this.source = source;
        this.ip = ip;
        this.prefixLengthV4 = prefixLengthV4;
        this.prefixLengthV6 = prefixLengthV6;
        this.scratch = scratch;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.ip.baseRamBytesUsed();
        baseRamBytesUsed += this.prefixLengthV4.baseRamBytesUsed();
        return baseRamBytesUsed += this.prefixLengthV6.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock ipBlock, IntBlock prefixLengthV4Block, IntBlock prefixLengthV6Block) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef ipScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (ipBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (ipBlock.getValueCount(p) != 1) {
                    if (ipBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (prefixLengthV4Block.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (prefixLengthV4Block.getValueCount(p) != 1) {
                    if (prefixLengthV4Block.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (prefixLengthV6Block.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (prefixLengthV6Block.getValueCount(p) != 1) {
                    if (prefixLengthV6Block.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendBytesRef(IpPrefix.process(ipBlock.getBytesRef(ipBlock.getFirstValueIndex(p), ipScratch), prefixLengthV4Block.getInt(prefixLengthV4Block.getFirstValueIndex(p)), prefixLengthV6Block.getInt(prefixLengthV6Block.getFirstValueIndex(p)), this.scratch));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector ipVector, IntVector prefixLengthV4Vector, IntVector prefixLengthV6Vector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef ipScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendBytesRef(IpPrefix.process(ipVector.getBytesRef(p, ipScratch), prefixLengthV4Vector.getInt(p), prefixLengthV6Vector.getInt(p), this.scratch));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "IpPrefixEvaluator[ip=" + String.valueOf(this.ip) + ", prefixLengthV4=" + String.valueOf(this.prefixLengthV4) + ", prefixLengthV6=" + String.valueOf(this.prefixLengthV6) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.ip, this.prefixLengthV4, this.prefixLengthV6});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory ip;
        private final EvalOperator.ExpressionEvaluator.Factory prefixLengthV4;
        private final EvalOperator.ExpressionEvaluator.Factory prefixLengthV6;
        private final Function<DriverContext, BytesRef> scratch;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory ip, EvalOperator.ExpressionEvaluator.Factory prefixLengthV4, EvalOperator.ExpressionEvaluator.Factory prefixLengthV6, Function<DriverContext, BytesRef> scratch) {
            this.source = source;
            this.ip = ip;
            this.prefixLengthV4 = prefixLengthV4;
            this.prefixLengthV6 = prefixLengthV6;
            this.scratch = scratch;
        }

        public IpPrefixEvaluator get(DriverContext context) {
            return new IpPrefixEvaluator(this.source, this.ip.get(context), this.prefixLengthV4.get(context), this.prefixLengthV6.get(context), this.scratch.apply(context), context);
        }

        public String toString() {
            return "IpPrefixEvaluator[ip=" + String.valueOf(this.ip) + ", prefixLengthV4=" + String.valueOf(this.prefixLengthV4) + ", prefixLengthV6=" + String.valueOf(this.prefixLengthV6) + "]";
        }
    }
}

