/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matchers;

public abstract class OffsetDocValuesLoaderTestCase
extends MapperServiceTestCase {
    @Override
    protected Settings getIndexSettings() {
        return Settings.builder().put("index.mapping.source.mode", "synthetic").put("index.mapping.synthetic_source_keep", "arrays").build();
    }

    public void testOffsetArrayNoDocValues() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        mapping.field("doc_values", false);
        mapping.endObject().endObject().endObject().endObject();
        try (MapperService mapperService = this.createMapperService(mapping);){
            Mapper fieldMapper = mapperService.mappingLookup().getMapper("field");
            OffsetDocValuesLoaderTestCase.assertThat(fieldMapper.getOffsetFieldName(), Matchers.nullValue());
        }
    }

    public void testOffsetArrayStored() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        mapping.field("store", true);
        mapping.endObject().endObject().endObject().endObject();
        try (MapperService mapperService = this.createMapperService(mapping);){
            Mapper fieldMapper = mapperService.mappingLookup().getMapper("field");
            OffsetDocValuesLoaderTestCase.assertThat(fieldMapper.getOffsetFieldName(), Matchers.nullValue());
        }
    }

    public void testOffsetMultiFields() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        mapping.startObject("fields").startObject("sub").field("type", "text").endObject().endObject();
        mapping.endObject().endObject().endObject().endObject();
        try (MapperService mapperService = this.createMapperService(mapping);){
            Mapper fieldMapper = mapperService.mappingLookup().getMapper("field");
            OffsetDocValuesLoaderTestCase.assertThat(fieldMapper.getOffsetFieldName(), Matchers.nullValue());
        }
    }

    public void testOffsetArrayNoSyntheticSource() throws Exception {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        mapping.endObject().endObject().endObject().endObject();
        try (MapperService mapperService = this.createMapperService(Settings.EMPTY, mapping);){
            Mapper fieldMapper = mapperService.mappingLookup().getMapper("field");
            OffsetDocValuesLoaderTestCase.assertThat(fieldMapper.getOffsetFieldName(), Matchers.nullValue());
        }
    }

    public void testOffsetArrayNoSourceArrayKeep() throws Exception {
        Settings.Builder settingsBuilder = Settings.builder().put("index.mapping.source.mode", "synthetic");
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        if (OffsetDocValuesLoaderTestCase.randomBoolean()) {
            mapping.field("synthetic_source_keep", OffsetDocValuesLoaderTestCase.randomBoolean() ? "none" : "all");
        } else if (OffsetDocValuesLoaderTestCase.randomBoolean()) {
            settingsBuilder.put("index.mapping.synthetic_source_keep", "none");
        }
        mapping.endObject().endObject().endObject().endObject();
        try (MapperService mapperService = this.createMapperService(settingsBuilder.build(), mapping);){
            Mapper fieldMapper = mapperService.mappingLookup().getMapper("field");
            OffsetDocValuesLoaderTestCase.assertThat(fieldMapper.getOffsetFieldName(), Matchers.nullValue());
        }
    }

    public void testOffsetEmptyArray() throws Exception {
        this.verifyOffsets("{\"field\":[]}");
    }

    public void testOffsetArrayWithNulls() throws Exception {
        this.verifyOffsets("{\"field\":[null,null,null]}");
        this.verifyOffsets("{\"field\":[null,[null],null]}", "{\"field\":[null,null,null]}");
    }

    public void testOffsetArrayRandom() throws Exception {
        String values;
        int numValues = OffsetDocValuesLoaderTestCase.randomIntBetween(0, 256);
        HashSet<Object> previousValues = new HashSet<Object>();
        try (XContentBuilder b = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
            b.startArray();
            for (int i = 0; i < numValues; ++i) {
                if (OffsetDocValuesLoaderTestCase.randomInt(10) == 1) {
                    b.nullValue();
                    continue;
                }
                if (OffsetDocValuesLoaderTestCase.randomInt(10) == 1 && previousValues.size() > 0) {
                    b.value(OffsetDocValuesLoaderTestCase.randomFrom(previousValues));
                    continue;
                }
                Object value = this.randomValue();
                previousValues.add(value);
                b.value(value);
            }
            b.endArray();
            values = Strings.toString((XContentBuilder)b);
        }
        this.verifyOffsets("{\"field\":" + values + "}");
    }

    protected void minimalMapping(XContentBuilder b) throws IOException {
        String fieldTypeName = this.getFieldTypeName();
        OffsetDocValuesLoaderTestCase.assertThat(fieldTypeName, Matchers.notNullValue());
        b.field("type", fieldTypeName);
    }

    protected abstract String getFieldTypeName();

    protected abstract Object randomValue();

    protected void verifyOffsets(String source) throws IOException {
        this.verifyOffsets(source, source);
    }

    protected void verifyOffsets(String source, String expectedSource) throws IOException {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties").startObject("field");
        this.minimalMapping(mapping);
        mapping.endObject().endObject().endObject().endObject();
        this.verifyOffsets(mapping, source, expectedSource);
    }

    private void verifyOffsets(XContentBuilder mapping, String source, String expectedSource) throws IOException {
        try (MapperService mapperService = this.createMapperService(mapping);){
            DocumentMapper mapper = mapperService.documentMapper();
            try (BaseDirectoryWrapper directory = OffsetDocValuesLoaderTestCase.newDirectory();){
                RandomIndexWriter iw = this.indexWriterForSyntheticSource((Directory)directory);
                ParsedDocument doc = mapper.parse(new SourceToParse("_id", (BytesReference)new BytesArray(source), XContentType.JSON));
                doc.updateSeqID(0L, 0L);
                doc.version().setLongValue(0L);
                iw.addDocuments((Iterable)doc.docs());
                iw.close();
                try (DirectoryReader indexReader = OffsetDocValuesLoaderTestCase.wrapInMockESDirectoryReader(DirectoryReader.open((Directory)directory));){
                    FieldMapper fieldMapper = (FieldMapper)mapper.mappers().getMapper("field");
                    SourceLoader.SyntheticFieldLoader syntheticSourceLoader = fieldMapper.syntheticFieldLoader();
                    LeafReader leafReader = ((LeafReaderContext)indexReader.leaves().getFirst()).reader();
                    SourceLoader.SyntheticFieldLoader.DocValuesLoader docValueLoader = syntheticSourceLoader.docValuesLoader(leafReader, new int[]{0});
                    OffsetDocValuesLoaderTestCase.assertTrue((boolean)docValueLoader.advanceToDoc(0));
                    OffsetDocValuesLoaderTestCase.assertTrue((boolean)syntheticSourceLoader.hasValue());
                    XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
                    syntheticSourceLoader.write(builder);
                    builder.endObject();
                    String actual = Strings.toString((XContentBuilder)builder);
                    OffsetDocValuesLoaderTestCase.assertEquals((Object)expectedSource, (Object)actual);
                }
            }
        }
    }
}

