/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration;

import org.elasticsearch.datageneration.FieldDataGenerator;
import org.elasticsearch.datageneration.datasource.DataSource;
import org.elasticsearch.datageneration.fields.leaf.BooleanFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.ByteFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.ConstantKeywordFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.CountedKeywordFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.DateFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.DoubleFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.FloatFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.GeoPointFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.HalfFloatFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.IntegerFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.IpFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.KeywordFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.LongFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.ScaledFloatFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.ShortFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.TextFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.UnsignedLongFieldDataGenerator;
import org.elasticsearch.datageneration.fields.leaf.WildcardFieldDataGenerator;

public enum FieldType {
    KEYWORD("keyword"),
    LONG("long"),
    UNSIGNED_LONG("unsigned_long"),
    INTEGER("integer"),
    SHORT("short"),
    BYTE("byte"),
    DOUBLE("double"),
    FLOAT("float"),
    HALF_FLOAT("half_float"),
    SCALED_FLOAT("scaled_float"),
    COUNTED_KEYWORD("counted_keyword"),
    BOOLEAN("boolean"),
    DATE("date"),
    GEO_POINT("geo_point"),
    TEXT("text"),
    IP("ip"),
    CONSTANT_KEYWORD("constant_keyword"),
    WILDCARD("wildcard");

    private final String name;

    private FieldType(String name) {
        this.name = name;
    }

    public FieldDataGenerator generator(String fieldName, DataSource dataSource) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new KeywordFieldDataGenerator(dataSource);
            case 1 -> new LongFieldDataGenerator(fieldName, dataSource);
            case 2 -> new UnsignedLongFieldDataGenerator(fieldName, dataSource);
            case 3 -> new IntegerFieldDataGenerator(fieldName, dataSource);
            case 4 -> new ShortFieldDataGenerator(fieldName, dataSource);
            case 5 -> new ByteFieldDataGenerator(fieldName, dataSource);
            case 6 -> new DoubleFieldDataGenerator(fieldName, dataSource);
            case 7 -> new FloatFieldDataGenerator(fieldName, dataSource);
            case 8 -> new HalfFloatFieldDataGenerator(fieldName, dataSource);
            case 9 -> new ScaledFloatFieldDataGenerator(fieldName, dataSource);
            case 10 -> new CountedKeywordFieldDataGenerator(fieldName, dataSource);
            case 11 -> new BooleanFieldDataGenerator(dataSource);
            case 12 -> new DateFieldDataGenerator(dataSource);
            case 13 -> new GeoPointFieldDataGenerator(dataSource);
            case 14 -> new TextFieldDataGenerator(dataSource);
            case 15 -> new IpFieldDataGenerator(dataSource);
            case 16 -> new ConstantKeywordFieldDataGenerator();
            case 17 -> new WildcardFieldDataGenerator(dataSource);
        };
    }

    public static FieldType tryParse(String name) {
        return switch (name) {
            case "keyword" -> KEYWORD;
            case "long" -> LONG;
            case "unsigned_long" -> UNSIGNED_LONG;
            case "integer" -> INTEGER;
            case "short" -> SHORT;
            case "byte" -> BYTE;
            case "double" -> DOUBLE;
            case "float" -> FLOAT;
            case "half_float" -> HALF_FLOAT;
            case "scaled_float" -> SCALED_FLOAT;
            case "counted_keyword" -> COUNTED_KEYWORD;
            case "boolean" -> BOOLEAN;
            case "date" -> DATE;
            case "geo_point" -> GEO_POINT;
            case "text" -> TEXT;
            case "ip" -> IP;
            case "constant_keyword" -> CONSTANT_KEYWORD;
            case "wildcard" -> WILDCARD;
            default -> null;
        };
    }

    public String toString() {
        return this.name;
    }
}

