/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryTimingType;

final class ProfileScorer
extends Scorer {
    private final Scorer scorer;
    private final Timer scoreTimer;
    private final Timer nextDocTimer;
    private final Timer advanceTimer;
    private final Timer matchTimer;
    private final Timer shallowAdvanceTimer;
    private final Timer computeMaxScoreTimer;
    private final Timer setMinCompetitiveScoreTimer;

    ProfileScorer(Scorer scorer, QueryProfileBreakdown profile) {
        this.scorer = scorer;
        this.scoreTimer = profile.getNewTimer(QueryTimingType.SCORE);
        this.nextDocTimer = profile.getNewTimer(QueryTimingType.NEXT_DOC);
        this.advanceTimer = profile.getNewTimer(QueryTimingType.ADVANCE);
        this.matchTimer = profile.getNewTimer(QueryTimingType.MATCH);
        this.shallowAdvanceTimer = profile.getNewTimer(QueryTimingType.SHALLOW_ADVANCE);
        this.computeMaxScoreTimer = profile.getNewTimer(QueryTimingType.COMPUTE_MAX_SCORE);
        this.setMinCompetitiveScoreTimer = profile.getNewTimer(QueryTimingType.SET_MIN_COMPETITIVE_SCORE);
    }

    public int docID() {
        return this.scorer.docID();
    }

    public float score() throws IOException {
        this.scoreTimer.start();
        try {
            float f = this.scorer.score();
            return f;
        }
        finally {
            this.scoreTimer.stop();
        }
    }

    public Collection<Scorable.ChildScorable> getChildren() throws IOException {
        return this.scorer.getChildren();
    }

    public DocIdSetIterator iterator() {
        return new TimedDocIdSetIterator(this.scorer.iterator());
    }

    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.scorer.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        return new TwoPhaseIterator(new TimedDocIdSetIterator(in.approximation())){

            public boolean matches() throws IOException {
                ProfileScorer.this.matchTimer.start();
                try {
                    boolean bl = in.matches();
                    return bl;
                }
                finally {
                    ProfileScorer.this.matchTimer.stop();
                }
            }

            public float matchCost() {
                return in.matchCost();
            }
        };
    }

    public int advanceShallow(int target) throws IOException {
        this.shallowAdvanceTimer.start();
        try {
            int n = this.scorer.advanceShallow(target);
            return n;
        }
        finally {
            this.shallowAdvanceTimer.stop();
        }
    }

    public float getMaxScore(int upTo) throws IOException {
        this.computeMaxScoreTimer.start();
        try {
            float f = this.scorer.getMaxScore(upTo);
            return f;
        }
        finally {
            this.computeMaxScoreTimer.stop();
        }
    }

    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.setMinCompetitiveScoreTimer.start();
        try {
            this.scorer.setMinCompetitiveScore(minScore);
        }
        finally {
            this.setMinCompetitiveScoreTimer.stop();
        }
    }

    private class TimedDocIdSetIterator
    extends DocIdSetIterator {
        private final DocIdSetIterator in;

        TimedDocIdSetIterator(DocIdSetIterator in) {
            this.in = in;
        }

        public int advance(int target) throws IOException {
            ProfileScorer.this.advanceTimer.start();
            try {
                int n = this.in.advance(target);
                return n;
            }
            finally {
                ProfileScorer.this.advanceTimer.stop();
            }
        }

        public int nextDoc() throws IOException {
            ProfileScorer.this.nextDocTimer.start();
            try {
                int n = this.in.nextDoc();
                return n;
            }
            finally {
                ProfileScorer.this.nextDocTimer.stop();
            }
        }

        public int docID() {
            return this.in.docID();
        }

        public long cost() {
            return this.in.cost();
        }
    }
}

