/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class RecyclerBytesStreamOutput
extends BytesStream
implements Releasable {
    static final VarHandle VH_BE_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
    static final VarHandle VH_LE_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    static final VarHandle VH_BE_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
    static final VarHandle VH_LE_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private ArrayList<Recycler.V<BytesRef>> pages = new ArrayList();
    private final Recycler<BytesRef> recycler;
    private final int pageSize;
    private int pageIndex = -1;
    private int currentCapacity = 0;
    private int currentPageOffset;

    public RecyclerBytesStreamOutput(Recycler<BytesRef> recycler) {
        this.recycler = recycler;
        this.currentPageOffset = this.pageSize = recycler.pageSize();
    }

    @Override
    public long position() {
        return (long)this.pageSize * (long)this.pageIndex + (long)this.currentPageOffset;
    }

    @Override
    public void writeByte(byte b) {
        int currentPageOffset = this.currentPageOffset;
        if (1 > this.pageSize - currentPageOffset) {
            this.ensureCapacity(1);
            currentPageOffset = 0;
        }
        BytesRef currentPage = this.pages.get(this.pageIndex).v();
        currentPage.bytes[currentPage.offset + currentPageOffset] = b;
        this.currentPageOffset = currentPageOffset + 1;
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) {
        int toCopyThisLoop;
        if (length == 0) {
            return;
        }
        Objects.checkFromIndexSize(offset, length, b.length);
        int pageSize = this.pageSize;
        int currentPageOffset = this.currentPageOffset;
        if (length > pageSize - currentPageOffset) {
            this.ensureCapacity(length);
            currentPageOffset = this.currentPageOffset;
        }
        int bytesToCopy = length;
        int srcOff = offset;
        int j = 0;
        while (true) {
            BytesRef currentPage = this.pages.get(this.pageIndex + j).v();
            toCopyThisLoop = Math.min(pageSize - currentPageOffset, bytesToCopy);
            System.arraycopy(b, srcOff, currentPage.bytes, currentPage.offset + currentPageOffset, toCopyThisLoop);
            srcOff += toCopyThisLoop;
            if ((bytesToCopy -= toCopyThisLoop) <= 0) break;
            currentPageOffset = 0;
            ++j;
        }
        this.currentPageOffset = currentPageOffset += toCopyThisLoop;
        this.pageIndex += j;
    }

    @Override
    public void writeInt(int i) throws IOException {
        int currentPageOffset = this.currentPageOffset;
        if (4 > this.pageSize - currentPageOffset) {
            super.writeInt(i);
        } else {
            BytesRef currentPage = this.pages.get(this.pageIndex).v();
            VH_BE_INT.set(currentPage.bytes, currentPage.offset + currentPageOffset, i);
            this.currentPageOffset = currentPageOffset + 4;
        }
    }

    @Override
    public void writeIntLE(int i) throws IOException {
        if (4 > this.pageSize - this.currentPageOffset) {
            super.writeIntLE(i);
        } else {
            BytesRef currentPage = this.pages.get(this.pageIndex).v();
            VH_LE_INT.set(currentPage.bytes, currentPage.offset + this.currentPageOffset, i);
            this.currentPageOffset += 4;
        }
    }

    @Override
    public void writeLong(long i) throws IOException {
        int currentPageOffset = this.currentPageOffset;
        if (8 > this.pageSize - currentPageOffset) {
            super.writeLong(i);
        } else {
            BytesRef currentPage = this.pages.get(this.pageIndex).v();
            VH_BE_LONG.set(currentPage.bytes, currentPage.offset + currentPageOffset, i);
            this.currentPageOffset = currentPageOffset + 8;
        }
    }

    @Override
    public void writeLongLE(long i) throws IOException {
        if (8 > this.pageSize - this.currentPageOffset) {
            super.writeLongLE(i);
        } else {
            BytesRef currentPage = this.pages.get(this.pageIndex).v();
            VH_LE_LONG.set(currentPage.bytes, currentPage.offset + this.currentPageOffset, i);
            this.currentPageOffset += 8;
        }
    }

    @Override
    public void legacyWriteWithSizePrefix(Writeable writeable) throws IOException {
        try (RecyclerBytesStreamOutput tmp = new RecyclerBytesStreamOutput(this.recycler);){
            tmp.setTransportVersion(this.getTransportVersion());
            writeable.writeTo(tmp);
            int size = tmp.size();
            this.writeVInt(size);
            int tmpPage = 0;
            while (size > 0) {
                Recycler.V<BytesRef> p = tmp.pages.get(tmpPage);
                BytesRef b = p.v();
                int writeSize = Math.min(size, b.length);
                this.writeBytes(b.bytes, b.offset, writeSize);
                ((Recycler.V)tmp.pages.set(tmpPage, null)).close();
                size -= writeSize;
                ++tmpPage;
            }
        }
    }

    @Override
    public void writeString(String str) throws IOException {
        int currentPageOffset = this.currentPageOffset;
        int charCount = str.length();
        if (charCount * 3 + 5 > this.pageSize - currentPageOffset) {
            super.writeString(str);
            return;
        }
        BytesRef currentPage = this.pages.get(this.pageIndex).v();
        int off = currentPage.offset + currentPageOffset;
        byte[] buffer = currentPage.bytes;
        int offset = off + RecyclerBytesStreamOutput.putVInt(buffer, charCount, off);
        for (int i = 0; i < charCount; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                buffer[offset++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
                buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
            buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.currentPageOffset = offset - currentPage.offset;
    }

    @Override
    public void flush() {
    }

    @Override
    public void seek(long position) {
        this.ensureCapacityFromPosition(position);
        int offsetInPage = (int)(position % (long)this.pageSize);
        int pageIndex = (int)position / this.pageSize;
        if (offsetInPage == 0) {
            this.pageIndex = pageIndex - 1;
            this.currentPageOffset = this.pageSize;
        } else {
            this.pageIndex = pageIndex;
            this.currentPageOffset = offsetInPage;
        }
    }

    public void skip(int length) {
        this.seek(this.position() + (long)length);
    }

    @Override
    public void close() {
        ArrayList<Recycler.V<BytesRef>> pages = this.pages;
        if (pages != null) {
            this.pages = null;
            Releasables.close(pages);
        }
    }

    public ReleasableBytesReference moveToBytesReference() {
        BytesReference bytes = this.bytes();
        ArrayList<Recycler.V<BytesRef>> pages = this.pages;
        this.pages = null;
        return new ReleasableBytesReference(bytes, () -> Releasables.close((Iterable)pages));
    }

    public int size() {
        return Math.toIntExact(this.position());
    }

    @Override
    public BytesReference bytes() {
        int bytesInLastPage;
        int adjustment;
        int position = (int)this.position();
        if (position == 0) {
            return BytesArray.EMPTY;
        }
        int remainder = position % this.pageSize;
        if (remainder != 0) {
            adjustment = 1;
            bytesInLastPage = remainder;
        } else {
            adjustment = 0;
            bytesInLastPage = this.pageSize;
        }
        int pageCount = position / this.pageSize + adjustment;
        if (pageCount == 1) {
            BytesRef page = this.pages.get(0).v();
            return new BytesArray(page.bytes, page.offset, bytesInLastPage);
        }
        BytesReference[] references = new BytesReference[pageCount];
        for (int i = 0; i < pageCount - 1; ++i) {
            references[i] = new BytesArray(this.pages.get(i).v());
        }
        BytesRef last = this.pages.get(pageCount - 1).v();
        references[pageCount - 1] = new BytesArray(last.bytes, last.offset, bytesInLastPage);
        return CompositeBytesReference.of(references);
    }

    private void ensureCapacity(int bytesNeeded) {
        assert (bytesNeeded > this.pageSize - this.currentPageOffset);
        this.ensureCapacityFromPosition(this.position() + (long)bytesNeeded);
    }

    private void ensureCapacityFromPosition(long newPosition) {
        if (newPosition > (long)(Integer.MAX_VALUE - Integer.MAX_VALUE % this.pageSize)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " cannot hold more than 2GB of data");
        }
        while (newPosition > (long)this.currentCapacity) {
            Recycler.V<BytesRef> newPage = this.recycler.obtain();
            assert (this.pageSize == newPage.v().length);
            this.pages.add(newPage);
            this.currentCapacity += this.pageSize;
        }
        if (this.currentPageOffset == this.pageSize) {
            ++this.pageIndex;
            this.currentPageOffset = 0;
        }
    }
}

