/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class Decision
implements ToXContent,
Writeable {
    public static final Decision ALWAYS = new Single(Type.YES);
    public static final Decision YES = new Single(Type.YES);
    public static final Decision NO = new Single(Type.NO);
    public static final Decision THROTTLE = new Single(Type.THROTTLE);

    public static Decision single(Type type, @Nullable String label, @Nullable String explanation, Object ... explanationParams) {
        return new Single(type, label, explanation, explanationParams);
    }

    public static Decision readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            Multi result = new Multi();
            int decisionCount = in.readVInt();
            for (int i = 0; i < decisionCount; ++i) {
                Decision s = Decision.readFrom(in);
                result.decisions.add(s);
            }
            return result;
        }
        Type type = Type.readFrom(in);
        String label = in.readOptionalString();
        String explanation = in.readOptionalString();
        if (label == null && explanation == null) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> YES;
                case 1 -> THROTTLE;
                case 2 -> NO;
            };
        }
        return new Single(type, label, explanation, new Object[0]);
    }

    public abstract Type type();

    @Nullable
    public abstract String label();

    @Nullable
    public abstract String getExplanation();

    public abstract List<Decision> getDecisions();

    public static class Single
    extends Decision
    implements ToXContentObject {
        private final Type type;
        private final String label;
        private final String explanationString;

        private Single(Type type) {
            this(type, null, null, null);
        }

        public Single(Type type, @Nullable String label, @Nullable String explanation, Object ... explanationParams) {
            this.type = type;
            this.label = label;
            this.explanationString = explanationParams != null && explanationParams.length > 0 ? String.format(Locale.ROOT, explanation, explanationParams) : explanation;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        @Nullable
        public String label() {
            return this.label;
        }

        @Override
        public List<Decision> getDecisions() {
            return Collections.singletonList(this);
        }

        @Override
        @Nullable
        public String getExplanation() {
            return this.explanationString;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Single s = (Single)object;
            return this.type == s.type && Objects.equals(this.label, s.label) && Objects.equals(this.explanationString, s.explanationString);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            String explanationStr = this.explanationString;
            result = 31 * result + (explanationStr == null ? 0 : explanationStr.hashCode());
            return result;
        }

        public String toString() {
            if (this.explanationString != null) {
                return String.valueOf(this.type) + "(" + this.explanationString + ")";
            }
            return String.valueOf(this.type) + "()";
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("decider", this.label);
            builder.field("decision", (Enum)this.type);
            builder.field("explanation", this.explanationString != null ? this.explanationString : "none");
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(false);
            this.type.writeTo(out);
            out.writeOptionalString(this.label);
            out.writeOptionalString(this.explanationString);
        }
    }

    public static enum Type implements Writeable
    {
        YES(1),
        THROTTLE(2),
        NO(0);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public static Type readFrom(StreamInput in) throws IOException {
            int i = in.readVInt();
            return switch (i) {
                case 0 -> NO;
                case 1 -> YES;
                case 2 -> THROTTLE;
                default -> throw new IllegalArgumentException("No Type for integer [" + i + "]");
            };
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.id);
        }

        public boolean higherThan(Type other) {
            if (this == NO) {
                return false;
            }
            if (other == NO) {
                return true;
            }
            return other == THROTTLE && this == YES;
        }
    }

    public static class Multi
    extends Decision
    implements ToXContentFragment {
        private final List<Decision> decisions = new ArrayList<Decision>();

        public Multi add(Decision decision) {
            this.decisions.add(decision);
            return this;
        }

        @Override
        public Type type() {
            Type ret = Type.YES;
            for (int i = 0; i < this.decisions.size(); ++i) {
                Type type = this.decisions.get(i).type();
                if (type == Type.NO) {
                    return type;
                }
                if (type != Type.THROTTLE) continue;
                ret = type;
            }
            return ret;
        }

        @Override
        @Nullable
        public String label() {
            return null;
        }

        @Override
        @Nullable
        public String getExplanation() {
            throw new UnsupportedOperationException("multi-level decisions do not have an explanation");
        }

        @Override
        public List<Decision> getDecisions() {
            return Collections.unmodifiableList(this.decisions);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Multi m = (Multi)object;
            return this.decisions.equals(m.decisions);
        }

        public int hashCode() {
            return 31 * this.decisions.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Decision decision : this.decisions) {
                sb.append("[").append(decision.toString()).append("]");
            }
            return sb.toString();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (Decision d : this.decisions) {
                d.toXContent(builder, params);
            }
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(true);
            out.writeCollection(this.getDecisions());
        }
    }
}

