/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.metadata.DesiredNode;
import org.elasticsearch.cluster.metadata.DesiredNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DesiredNodeWithStatus(DesiredNode desiredNode, Status status) implements Writeable,
ToXContentObject,
Comparable<DesiredNodeWithStatus>
{
    private static final TransportVersion STATUS_TRACKING_SUPPORT_VERSION = TransportVersions.V_8_4_0;
    private static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
    public static final ConstructingObjectParser<DesiredNodeWithStatus, Void> PARSER = new ConstructingObjectParser("desired_node_with_status", false, (args, unused) -> new DesiredNodeWithStatus(new DesiredNode((Settings)args[0], (Processors)args[1], (DesiredNode.ProcessorsRange)args[2], (ByteSizeValue)args[3], (ByteSizeValue)args[4]), args[5] == null ? Status.PENDING : (Status)((Object)((Object)args[5]))));

    public boolean pending() {
        return this.status == Status.PENDING;
    }

    public boolean actualized() {
        return this.status == Status.ACTUALIZED;
    }

    public String externalId() {
        return this.desiredNode.externalId();
    }

    public static DesiredNodeWithStatus readFrom(StreamInput in) throws IOException {
        DesiredNode desiredNode = DesiredNode.readFrom(in);
        Status status = in.getTransportVersion().onOrAfter(STATUS_TRACKING_SUPPORT_VERSION) ? Status.fromValue(in.readShort()) : Status.PENDING;
        return new DesiredNodeWithStatus(desiredNode, status);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.desiredNode.writeTo(out);
        if (out.getTransportVersion().onOrAfter(STATUS_TRACKING_SUPPORT_VERSION)) {
            out.writeShort(this.status.value);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        DesiredNodes.SerializationContext desiredNodesSerializationContext = DesiredNodes.SerializationContext.valueOf(params.param("desired_nodes_x_content_context", DesiredNodes.CONTEXT_MODE_CLUSTER_STATE));
        builder.startObject();
        this.desiredNode.toInnerXContent(builder, params);
        if (desiredNodesSerializationContext == DesiredNodes.SerializationContext.CLUSTER_STATE) {
            builder.field(STATUS_FIELD.getPreferredName(), this.status.value);
        }
        builder.endObject();
        return builder;
    }

    static DesiredNodeWithStatus fromXContent(XContentParser parser) throws IOException {
        return (DesiredNodeWithStatus)PARSER.parse(parser, null);
    }

    @Override
    public int compareTo(DesiredNodeWithStatus o) {
        return this.desiredNode.compareTo(o.desiredNode);
    }

    public boolean equalsWithProcessorsCloseTo(DesiredNodeWithStatus other) {
        return other != null && this.status == other.status && this.desiredNode.equalsWithProcessorsCloseTo(other.desiredNode);
    }

    static {
        DesiredNode.configureParser(PARSER);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Status.fromValue(p.shortValue()), STATUS_FIELD, ObjectParser.ValueType.INT);
    }

    public static enum Status {
        PENDING(0),
        ACTUALIZED(1);

        private final short value;

        private Status(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        static Status fromValue(short value) {
            return switch (value) {
                case 0 -> PENDING;
                case 1 -> ACTUALIZED;
                default -> throw new IllegalArgumentException("Unknown status " + value);
            };
        }
    }
}

