/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.HashMap;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;

public class RrfScoreEvalOperator
extends AbstractPageMappingOperator {
    private final int scorePosition;
    private final int forkPosition;
    private HashMap<String, Integer> counters = new HashMap();

    public RrfScoreEvalOperator(int forkPosition, int scorePosition) {
        this.scorePosition = scorePosition;
        this.forkPosition = forkPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Page process(Page page) {
        BytesRefBlock forkBlock = (BytesRefBlock)page.getBlock(this.forkPosition);
        DoubleVector.Builder scores = forkBlock.blockFactory().newDoubleVectorBuilder(forkBlock.getPositionCount());
        for (int i = 0; i < page.getPositionCount(); ++i) {
            String fork = forkBlock.getBytesRef(i, new BytesRef()).utf8ToString();
            int rank = this.counters.getOrDefault(fork, 1);
            this.counters.put(fork, rank + 1);
            scores.appendDouble(1.0 / (double)(60 + rank));
        }
        DoubleBlock scoreBlock = scores.build().asBlock();
        page = page.appendBlock(scoreBlock);
        int[] projections = new int[page.getBlockCount() - 1];
        for (int i = 0; i < page.getBlockCount() - 1; ++i) {
            projections[i] = i == this.scorePosition ? page.getBlockCount() - 1 : i;
        }
        try {
            Page page2 = page.projectBlocks(projections);
            return page2;
        }
        finally {
            page.releaseBlocks();
        }
    }

    @Override
    public String toString() {
        return "RrfScoreEvalOperator";
    }

    public record Factory(int forkPosition, int scorePosition) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new RrfScoreEvalOperator(this.forkPosition, this.scorePosition);
        }

        @Override
        public String describe() {
            return "RrfScoreEvalOperator";
        }
    }
}

