/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.util.List;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.core.RefCounted;

public interface ShardRefCounted {
    public static final ShardRefCounted ALWAYS_REFERENCED = shardId -> RefCounted.ALWAYS_REFERENCED;

    public RefCounted get(int var1);

    public static ShardRefCounted fromList(List<? extends RefCounted> refCounters) {
        return shardId -> (RefCounted)refCounters.get(shardId);
    }

    public static ShardRefCounted fromShardContext(ShardContext shardContext) {
        return ShardRefCounted.single(shardContext.index(), shardContext);
    }

    public static ShardRefCounted single(int index, RefCounted refCounted) {
        return shardId -> {
            if (shardId != index) {
                throw new IllegalArgumentException("Invalid shardId: " + shardId + ", expected: " + index);
            }
            return refCounted;
        };
    }
}

