/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ConstantIntVector;
import org.elasticsearch.compute.data.IntArrayVector;
import org.elasticsearch.compute.data.IntVector;

public final class IntVectorFixedBuilder
implements IntVector.FixedBuilder {
    private final BlockFactory blockFactory;
    private final int[] values;
    private final long preAdjustedBytes;
    private int nextIndex;
    private boolean closed;

    IntVectorFixedBuilder(int size, BlockFactory blockFactory) {
        this.preAdjustedBytes = IntVectorFixedBuilder.ramBytesUsed(size);
        blockFactory.adjustBreaker(this.preAdjustedBytes);
        this.blockFactory = blockFactory;
        this.values = new int[size];
    }

    @Override
    public IntVectorFixedBuilder appendInt(int value) {
        this.values[this.nextIndex++] = value;
        return this;
    }

    @Override
    public IntVectorFixedBuilder appendInt(int idx, int value) {
        this.values[idx] = value;
        return this;
    }

    private static long ramBytesUsed(int size) {
        return size == 1 ? ConstantIntVector.RAM_BYTES_USED : IntArrayVector.BASE_RAM_BYTES_USED + RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)size * 4L));
    }

    @Override
    public long estimatedBytes() {
        return IntVectorFixedBuilder.ramBytesUsed(this.values.length);
    }

    @Override
    public IntVector build() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        this.closed = true;
        IntVector vector = this.values.length == 1 ? this.blockFactory.newConstantIntBlockWith(this.values[0], 1, this.preAdjustedBytes).asVector() : this.blockFactory.newIntArrayVector(this.values, this.values.length, this.preAdjustedBytes);
        assert (vector.ramBytesUsed() == this.preAdjustedBytes) : "fixed Builders should estimate the exact ram bytes used";
        return vector;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.blockFactory.adjustBreaker(-this.preAdjustedBytes);
        }
    }

    public boolean isReleased() {
        return this.closed;
    }
}

