/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.pipeline;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.RubyUtil;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.plugins.pipeline.AddressState;
import org.logstash.plugins.pipeline.PipelineBus;
import org.logstash.plugins.pipeline.PipelineInput;
import org.logstash.plugins.pipeline.ReceiveResponse;

public abstract class AbstractPipelineBus
implements PipelineBus {
    private static final Logger LOGGER = LogManager.getLogger(AbstractPipelineBus.class);

    protected static void doSendEvents(JrubyEventExtLibrary.RubyEvent[] orderedEvents, AddressState.ReadOnly addressState, boolean ensureDelivery) {
        boolean partialProcessing;
        boolean sendWasSuccess = false;
        ReceiveResponse lastResponse = null;
        int lastFailedPosition = 0;
        do {
            Stream<JrubyEventExtLibrary.RubyEvent> clones = Arrays.stream(orderedEvents).skip(lastFailedPosition).map(e -> e.rubyClone(RubyUtil.RUBY));
            PipelineInput input = addressState.getInput();
            if (input != null) {
                lastResponse = input.internalReceive(clones);
                sendWasSuccess = lastResponse.wasSuccess();
            }
            boolean bl = partialProcessing = ensureDelivery && !sendWasSuccess;
            if (!partialProcessing) continue;
            if (lastResponse != null && lastResponse.getStatus() == PipelineInput.ReceiveStatus.FAIL) {
                LOGGER.warn("Attempted to send events to '{}' but that address reached error condition with {} events remaining. Will Retry. Root cause {}", (Object)addressState.getAddress(), (Object)(orderedEvents.length - (lastFailedPosition += lastResponse.getSequencePosition().intValue())), (Object)lastResponse.getCauseMessage());
            } else {
                LOGGER.warn("Attempted to send event to '{}' but that address was unavailable. Maybe the destination pipeline is down or stopping? Will Retry.", (Object)addressState.getAddress());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                LOGGER.error("Sleep unexpectedly interrupted in bus retry loop", (Throwable)e2);
            }
        } while (partialProcessing);
    }
}

