/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.user;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class User
implements ToXContentObject {
    private final String username;
    private final String[] roles;
    private final Map<String, Object> metadata;
    private final boolean enabled;
    @Nullable
    private final String fullName;
    @Nullable
    private final String email;

    public User(String username, String ... roles) {
        this(username, roles, null, null, Map.of(), true);
    }

    public User(String username, String[] roles, String fullName, String email, Map<String, Object> metadata, boolean enabled) {
        this.username = Objects.requireNonNull(username);
        this.roles = roles == null ? Strings.EMPTY_ARRAY : roles;
        this.metadata = metadata == null ? Map.of() : metadata;
        this.fullName = fullName;
        this.email = email;
        this.enabled = enabled;
    }

    public String principal() {
        return this.username;
    }

    public String[] roles() {
        return this.roles;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public String fullName() {
        return this.fullName;
    }

    public String email() {
        return this.email;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("User[username=").append(this.username);
        sb.append(",roles=[").append(Strings.arrayToCommaDelimitedString(this.roles)).append("]");
        sb.append(",fullName=").append(this.fullName);
        sb.append(",email=").append(this.email);
        sb.append(",metadata=");
        sb.append(this.metadata);
        if (!this.enabled) {
            sb.append(",(disabled)");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        if (!this.username.equals(user.username)) {
            return false;
        }
        if (!Arrays.equals(this.roles, user.roles)) {
            return false;
        }
        if (!this.metadata.equals(user.metadata)) {
            return false;
        }
        return Objects.equals(this.fullName, user.fullName) && Objects.equals(this.email, user.email);
    }

    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + Arrays.hashCode(this.roles);
        result = 31 * result + this.metadata.hashCode();
        result = 31 * result + (this.fullName != null ? this.fullName.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        return result;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder);
        return builder.endObject();
    }

    public void innerToXContent(XContentBuilder builder) throws IOException {
        builder.field(Fields.USERNAME.getPreferredName(), this.principal());
        builder.array(Fields.ROLES.getPreferredName(), this.roles());
        builder.field(Fields.FULL_NAME.getPreferredName(), this.fullName());
        builder.field(Fields.EMAIL.getPreferredName(), this.email());
        builder.field(Fields.METADATA.getPreferredName(), this.metadata());
        builder.field(Fields.ENABLED.getPreferredName(), this.enabled());
    }

    public static void writeUser(User user, StreamOutput output) throws IOException {
        output.writeBoolean(false);
        output.writeString(user.username);
        output.writeStringArray(user.roles);
        output.writeGenericMap(user.metadata);
        output.writeOptionalString(user.fullName);
        output.writeOptionalString(user.email);
        output.writeBoolean(user.enabled);
    }

    public static interface Fields {
        public static final ParseField USERNAME = new ParseField("username", new String[0]);
        public static final ParseField PASSWORD = new ParseField("password", new String[0]);
        public static final ParseField PASSWORD_HASH = new ParseField("password_hash", new String[0]);
        public static final ParseField ROLES = new ParseField("roles", new String[0]);
        public static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
        public static final ParseField EMAIL = new ParseField("email", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
        public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField AUTHENTICATION_REALM = new ParseField("authentication_realm", new String[0]);
        public static final ParseField LOOKUP_REALM = new ParseField("lookup_realm", new String[0]);
        public static final ParseField REALM_TYPE = new ParseField("type", new String[0]);
        public static final ParseField REALM_NAME = new ParseField("name", new String[0]);
        public static final ParseField REALM_DOMAIN = new ParseField("domain", new String[0]);
        public static final ParseField AUTHENTICATION_TYPE = new ParseField("authentication_type", new String[0]);
        public static final ParseField TOKEN = new ParseField("token", new String[0]);
    }
}

