/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum PredictionFieldType implements Writeable
{
    STRING,
    NUMBER,
    BOOLEAN;

    private static final double EPS = 1.0E-9;

    public static PredictionFieldType fromString(String name) {
        return PredictionFieldType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static PredictionFieldType fromStream(StreamInput in) throws IOException {
        return in.readEnum(PredictionFieldType.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public Object transformPredictedValue(Double value, String stringRep) {
        if (value == null) {
            return null;
        }
        switch (this.ordinal()) {
            case 0: {
                return stringRep == null ? value.toString() : stringRep;
            }
            case 2: {
                if (PredictionFieldType.isNumberQuickCheck(stringRep)) {
                    try {
                        return Integer.parseInt(stringRep) == 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                } else if (PredictionFieldType.isBoolQuickCheck(stringRep)) {
                    return Boolean.parseBoolean(stringRep);
                }
                return PredictionFieldType.fromDouble(value);
            }
            case 1: {
                if (PredictionFieldType.isNumberQuickCheck(stringRep)) {
                    try {
                        return Long.parseLong(stringRep);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return value;
            }
        }
        return value;
    }

    private static boolean fromDouble(double value) {
        if (!(PredictionFieldType.areClose(value, 1.0) || PredictionFieldType.areClose(value, 0.0))) {
            throw new IllegalArgumentException("Cannot transform numbers other than 0.0 or 1.0 to boolean. Provided number [" + value + "]");
        }
        return PredictionFieldType.areClose(value, 1.0);
    }

    private static boolean areClose(double value1, double value2) {
        return Math.abs(value1 - value2) < 1.0E-9;
    }

    private static boolean isNumberQuickCheck(String stringRep) {
        return !Strings.isNullOrEmpty(stringRep) && (stringRep.charAt(0) == '-' || Character.isDigit(stringRep.charAt(0)));
    }

    private static boolean isBoolQuickCheck(String stringRep) {
        if (Strings.isNullOrEmpty(stringRep)) {
            return false;
        }
        char c = stringRep.charAt(0);
        return 't' == c || 'T' == c || 'f' == c || 'F' == c;
    }
}

