/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.RestCompatibleVersionHelper;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.telemetry.tracing.Traceable;
import org.elasticsearch.xcontent.ParsedMediaType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class RestRequest
implements ToXContent.Params,
Traceable {
    private static final Logger logger = LogManager.getLogger(RestRequest.class);
    public static final String SERVERLESS_REQUEST = "serverlessRequest";
    public static final String OPERATOR_REQUEST = "operatorRequest";
    public static final Set<String> INTERNAL_MARKER_REQUEST_PARAMETERS = Set.of("serverlessRequest", "operatorRequest");
    private static final Pattern TCHAR_PATTERN = Pattern.compile("[a-zA-Z0-9!#$%&'*+\\-.\\^_`|~]+");
    private static final AtomicLong requestIdGenerator = new AtomicLong();
    private final XContentParserConfiguration parserConfig;
    private final Map<String, String> params;
    private final Map<String, List<String>> headers;
    private final String rawPath;
    private final Set<String> consumedParams = new HashSet<String>();
    private final SetOnce<XContentType> xContentType = new SetOnce();
    private final HttpChannel httpChannel;
    private final ParsedMediaType parsedAccept;
    private final ParsedMediaType parsedContentType;
    private final Optional<RestApiVersion> restApiVersion;
    private HttpRequest httpRequest;
    private boolean contentConsumed = false;
    private final long requestId;

    public boolean isContentConsumed() {
        return this.contentConsumed;
    }

    protected RestRequest(XContentParserConfiguration parserConfig, Map<String, String> params, String rawPath, Map<String, List<String>> headers, HttpRequest httpRequest, HttpChannel httpChannel) {
        this(parserConfig, params, rawPath, headers, httpRequest, httpChannel, requestIdGenerator.incrementAndGet());
    }

    private RestRequest(XContentParserConfiguration parserConfig, Map<String, String> params, String rawPath, Map<String, List<String>> headers, HttpRequest httpRequest, HttpChannel httpChannel, long requestId) {
        try {
            this.parsedAccept = RestRequest.parseHeaderWithMediaType(httpRequest.getHeaders(), "Accept");
        }
        catch (IllegalArgumentException e) {
            throw new MediaTypeHeaderException(e, "Accept");
        }
        try {
            this.parsedContentType = RestRequest.parseHeaderWithMediaType(httpRequest.getHeaders(), "Content-Type");
            if (this.parsedContentType != null) {
                this.xContentType.set(this.parsedContentType.toMediaType(XContentType.MEDIA_TYPE_REGISTRY));
            }
        }
        catch (IllegalArgumentException e) {
            throw new MediaTypeHeaderException(e, "Content-Type");
        }
        this.httpRequest = httpRequest;
        try {
            this.restApiVersion = RestCompatibleVersionHelper.getCompatibleVersion(this.parsedAccept, this.parsedContentType, this.hasContent());
        }
        catch (ElasticsearchStatusException e) {
            throw new MediaTypeHeaderException(e, "Accept", "Content-Type");
        }
        RestApiVersion effectiveApiVersion = this.getRestApiVersion();
        this.parserConfig = parserConfig.restApiVersion().equals((Object)effectiveApiVersion) ? parserConfig : parserConfig.withRestApiVersion(effectiveApiVersion);
        this.httpChannel = httpChannel;
        this.params = params;
        this.rawPath = rawPath;
        this.headers = Collections.unmodifiableMap(headers);
        this.requestId = requestId;
    }

    protected RestRequest(RestRequest other) {
        assert (other.parserConfig.restApiVersion().equals((Object)other.getRestApiVersion()));
        this.parsedAccept = other.parsedAccept;
        this.parsedContentType = other.parsedContentType;
        if (other.xContentType.get() != null) {
            this.xContentType.set(other.xContentType.get());
        }
        this.restApiVersion = other.restApiVersion;
        this.parserConfig = other.parserConfig;
        this.httpRequest = other.httpRequest;
        this.httpChannel = other.httpChannel;
        this.params = other.params;
        this.rawPath = other.rawPath;
        this.headers = other.headers;
        this.requestId = other.requestId;
    }

    @Nullable
    private static ParsedMediaType parseHeaderWithMediaType(Map<String, List<String>> headers, String headerName) {
        List<String> header = headers.get(headerName);
        if (header == null || header.isEmpty()) {
            return null;
        }
        if (header.size() > 1) {
            throw new IllegalArgumentException("Incorrect header [" + headerName + "]. Only one value should be provided");
        }
        String rawContentType = header.get(0);
        if (Strings.hasText(rawContentType)) {
            return ParsedMediaType.parseMediaType(rawContentType);
        }
        throw new IllegalArgumentException("Header [" + headerName + "] cannot be empty.");
    }

    public static RestRequest request(XContentParserConfiguration parserConfig, HttpRequest httpRequest, HttpChannel httpChannel) {
        Map<String, String> params = RestRequest.params(httpRequest.uri());
        return new RestRequest(parserConfig, params, httpRequest.rawPath(), httpRequest.getHeaders(), httpRequest, httpChannel, requestIdGenerator.incrementAndGet());
    }

    private static Map<String, String> params(String uri) {
        HashMap<String, String> params = new HashMap<String, String>();
        int index = uri.indexOf(63);
        if (index >= 0) {
            try {
                RestUtils.decodeQueryString(uri, index + 1, params);
            }
            catch (IllegalArgumentException e) {
                throw new BadParameterException(e);
            }
        }
        return params;
    }

    public static RestRequest requestWithoutParameters(XContentParserConfiguration parserConfig, HttpRequest httpRequest, HttpChannel httpChannel) {
        Map<String, String> params = Collections.emptyMap();
        return new RestRequest(parserConfig, params, httpRequest.uri(), httpRequest.getHeaders(), httpRequest, httpChannel, requestIdGenerator.incrementAndGet());
    }

    public Method method() {
        return this.httpRequest.method();
    }

    public String uri() {
        return this.httpRequest.uri();
    }

    public String rawPath() {
        return this.rawPath;
    }

    public final String path() {
        return RestUtils.decodeComponent(this.rawPath());
    }

    public boolean hasContent() {
        return this.httpRequest.hasContent();
    }

    public int contentLength() {
        return this.httpRequest.body().asFull().bytes().length();
    }

    public boolean isFullContent() {
        return this.httpRequest.body().isFull();
    }

    public ReleasableBytesReference content() {
        this.contentConsumed = true;
        ReleasableBytesReference bytes = this.httpRequest.body().asFull().bytes();
        if (!bytes.hasReferences()) {
            IllegalStateException e = new IllegalStateException("http releasable content accessed after release");
            logger.error(e.getMessage(), (Throwable)e);
            assert (false) : e;
            throw e;
        }
        return bytes;
    }

    public boolean isStreamedContent() {
        return this.httpRequest.body().isStream();
    }

    public HttpBody.Stream contentStream() {
        this.contentConsumed = true;
        return this.httpRequest.body().asStream();
    }

    public ReleasableBytesReference requiredContent() {
        if (!this.hasContent()) {
            throw new ElasticsearchParseException("request body is required", new Object[0]);
        }
        if (this.xContentType.get() == null) {
            RestRequest.throwValidationException("unknown content type");
        }
        return this.content();
    }

    private static void throwValidationException(String msg) {
        ValidationException unknownContentType = new ValidationException();
        unknownContentType.addValidationError(msg);
        throw unknownContentType;
    }

    public final String header(String name) {
        List<String> values = this.headers.get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public final List<String> getAllHeaderValues(String name) {
        List<String> values = this.headers.get(name);
        if (values != null) {
            return Collections.unmodifiableList(values);
        }
        return null;
    }

    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public final long getRequestId() {
        return this.requestId;
    }

    @Nullable
    public final XContentType getXContentType() {
        return this.xContentType.get();
    }

    public HttpChannel getHttpChannel() {
        return this.httpChannel;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public final boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    @Override
    public final String param(String key) {
        this.consumedParams.add(key);
        return this.params.get(key);
    }

    @Override
    public final String param(String key, String defaultValue) {
        this.consumedParams.add(key);
        String value = this.params.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, String> params() {
        return this.params;
    }

    List<String> consumedParams() {
        return new ArrayList<String>(this.consumedParams);
    }

    List<String> unconsumedParams() {
        return this.params.keySet().stream().filter(p -> !this.consumedParams.contains(p)).toList();
    }

    public float paramAsFloat(String key, float defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse float parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public double paramAsDouble(String key, double defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse double parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public int paramAsInt(String key, int defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    public long paramAsLong(String key, long defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse long parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public boolean paramAsBoolean(String key, boolean defaultValue) {
        String rawParam = this.param(key);
        if (rawParam != null && rawParam.length() == 0) {
            return true;
        }
        return Booleans.parseBoolean(rawParam, defaultValue);
    }

    @Override
    public Boolean paramAsBoolean(String key, Boolean defaultValue) {
        return Booleans.parseBoolean(this.param(key), defaultValue);
    }

    public TimeValue paramAsTime(String key, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.param(key), defaultValue, key);
    }

    public ByteSizeValue paramAsSize(String key, ByteSizeValue defaultValue) {
        return ByteSizeValue.parseBytesSizeValue(this.param(key), defaultValue, key);
    }

    public String[] paramAsStringArray(String key, String[] defaultValue) {
        String value = this.param(key);
        if (value == null) {
            return defaultValue;
        }
        return Strings.splitStringByCommaToArray(value);
    }

    public String[] paramAsStringArrayOrEmptyIfAll(String key) {
        String[] params = this.paramAsStringArray(key, Strings.EMPTY_ARRAY);
        if (Strings.isAllOrWildcard(params)) {
            return Strings.EMPTY_ARRAY;
        }
        return params;
    }

    public XContentParserConfiguration contentParserConfig() {
        return this.parserConfig;
    }

    public final XContentParser contentParser() throws IOException {
        return this.contentParser(this.parserConfig);
    }

    private XContentParser contentParser(XContentParserConfiguration parserConfig) throws IOException {
        ReleasableBytesReference content = this.requiredContent();
        return XContentHelper.createParserNotCompressed(parserConfig, content, this.xContentType.get());
    }

    public final void applyContentParser(boolean includeSourceOnError, CheckedConsumer<XContentParser, IOException> applyParser) throws IOException {
        if (this.hasContent()) {
            try (XContentParser parser = this.contentParser(this.parserConfig.withIncludeSourceOnError(includeSourceOnError));){
                applyParser.accept(parser);
            }
        }
    }

    public final void applyContentParser(CheckedConsumer<XContentParser, IOException> applyParser) throws IOException {
        if (this.hasContent()) {
            try (XContentParser parser = this.contentParser(this.parserConfig);){
                applyParser.accept(parser);
            }
        }
    }

    public final boolean hasContentOrSourceParam() {
        return this.hasContent() || this.hasParam("source");
    }

    public final XContentParser contentOrSourceParamParser() throws IOException {
        Tuple<XContentType, ReleasableBytesReference> tuple = this.contentOrSourceParam();
        return XContentHelper.createParserNotCompressed(this.parserConfig, tuple.v2(), tuple.v1().xContent().type());
    }

    public final void withContentOrSourceParamParserOrNull(CheckedConsumer<XContentParser, IOException> withParser) throws IOException {
        if (this.hasContentOrSourceParam()) {
            Tuple<XContentType, ReleasableBytesReference> tuple = this.contentOrSourceParam();
            try (XContentParser parser = XContentHelper.createParserNotCompressed(this.parserConfig, tuple.v2(), tuple.v1());){
                withParser.accept(parser);
            }
        } else {
            withParser.accept(null);
        }
    }

    public final Tuple<XContentType, ReleasableBytesReference> contentOrSourceParam() {
        if (!this.hasContentOrSourceParam()) {
            throw new ElasticsearchParseException("request body or source parameter is required", new Object[0]);
        }
        if (this.hasContent()) {
            return new Tuple<XContentType, ReleasableBytesReference>(this.xContentType.get(), this.requiredContent());
        }
        String source = this.param("source");
        String typeParam = this.param("source_content_type");
        if (source == null || typeParam == null) {
            RestRequest.throwValidationException("source and source_content_type parameters are required");
        }
        BytesArray bytes = new BytesArray(source);
        XContentType xContentType = RestRequest.parseContentType(Collections.singletonList(typeParam));
        if (xContentType == null) {
            RestRequest.throwValidationException("Unknown value for source_content_type [" + typeParam + "]");
        }
        return new Tuple<XContentType, ReleasableBytesReference>(xContentType, ReleasableBytesReference.wrap(bytes));
    }

    public ParsedMediaType getParsedAccept() {
        return this.parsedAccept;
    }

    public ParsedMediaType getParsedContentType() {
        return this.parsedContentType;
    }

    public static XContentType parseContentType(List<String> header) {
        if (header == null || header.isEmpty()) {
            return null;
        }
        if (header.size() > 1) {
            throw new IllegalArgumentException("only one Content-Type header should be provided");
        }
        String rawContentType = header.get(0);
        String[] elements = rawContentType.split("[ \t]*;");
        if (elements.length > 0) {
            String[] splitMediaType = elements[0].split("/");
            if (splitMediaType.length == 2 && TCHAR_PATTERN.matcher(splitMediaType[0]).matches() && TCHAR_PATTERN.matcher(splitMediaType[1].trim()).matches()) {
                return XContentType.fromMediaType(elements[0]);
            }
            throw new IllegalArgumentException("invalid Content-Type header [" + rawContentType + "]");
        }
        throw new IllegalArgumentException("empty Content-Type header");
    }

    public RestApiVersion getRestApiVersion() {
        return this.restApiVersion.orElse(RestApiVersion.current());
    }

    public boolean hasExplicitRestApiVersion() {
        return this.restApiVersion.isPresent();
    }

    public void markAsServerlessRequest() {
        this.setParamTrueOnceAndConsume(SERVERLESS_REQUEST);
    }

    public boolean isServerlessRequest() {
        return this.paramAsBoolean(SERVERLESS_REQUEST, false);
    }

    public void markAsOperatorRequest() {
        this.setParamTrueOnceAndConsume(OPERATOR_REQUEST);
    }

    public boolean isOperatorRequest() {
        return this.paramAsBoolean(OPERATOR_REQUEST, false);
    }

    private void setParamTrueOnceAndConsume(String param) {
        if (this.params.containsKey(param)) {
            throw new IllegalArgumentException("The parameter [" + param + "] is already defined.");
        }
        this.params.put(param, "true");
        this.consumedParams.add(param);
    }

    @Override
    public String getSpanId() {
        return "rest-" + this.getRequestId();
    }

    public static class MediaTypeHeaderException
    extends RuntimeException {
        private final String message;
        private final Set<String> failedHeaderNames;

        MediaTypeHeaderException(RuntimeException cause, String ... failedHeaderNames) {
            super(cause);
            this.failedHeaderNames = Set.of(failedHeaderNames);
            this.message = "Invalid media-type value on headers " + String.valueOf(this.failedHeaderNames);
        }

        public Set<String> getFailedHeaderNames() {
            return this.failedHeaderNames;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class BadParameterException
    extends RuntimeException {
        BadParameterException(IllegalArgumentException cause) {
            super(cause);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD,
        PATCH,
        TRACE,
        CONNECT;

    }
}

