/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record;

import org.elasticsearch.ingest.geoip.shaded.com.fasterxml.jackson.annotation.JacksonInject;
import org.elasticsearch.ingest.geoip.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.elasticsearch.ingest.geoip.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.elasticsearch.ingest.geoip.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.elasticsearch.ingest.geoip.shaded.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.MaxMindDbConstructor;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.MaxMindDbParameter;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.db.Network;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.NetworkDeserializer;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.model.ConnectionTypeResponse;
import org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.record.AbstractRecord;

public final class Traits
extends AbstractRecord {
    private final Long autonomousSystemNumber;
    private final String autonomousSystemOrganization;
    private final ConnectionTypeResponse.ConnectionType connectionType;
    private final String domain;
    private final String ipAddress;
    private final boolean isAnonymous;
    private final boolean isAnonymousProxy;
    private final boolean isAnonymousVpn;
    private final boolean isAnycast;
    private final boolean isHostingProvider;
    private final boolean isLegitimateProxy;
    private final boolean isPublicProxy;
    private final boolean isResidentialProxy;
    private final boolean isSatelliteProvider;
    private final boolean isTorExitNode;
    private final String isp;
    private final String mobileCountryCode;
    private final String mobileNetworkCode;
    private final Network network;
    private final String organization;
    private final String userType;
    private final Integer userCount;
    private final Double staticIpScore;

    public Traits() {
        this((Long)null, (String)null, (ConnectionTypeResponse.ConnectionType)null, (String)null, (String)null, false, false, false, false, false, false, false, false, false, false, (String)null, (String)null, (String)null, (Network)null, (String)null, (String)null, (Integer)null, (Double)null);
    }

    public Traits(String ipAddress, Network network) {
        this((Long)null, (String)null, (ConnectionTypeResponse.ConnectionType)null, (String)null, ipAddress, false, false, false, false, false, false, false, false, false, false, (String)null, (String)null, (String)null, network, (String)null, (String)null, (Integer)null, (Double)null);
    }

    public Traits(@JsonProperty(value="autonomous_system_number") Long autonomousSystemNumber, @JsonProperty(value="autonomous_system_organization") String autonomousSystemOrganization, @JsonProperty(value="connection_type") ConnectionTypeResponse.ConnectionType connectionType, @JsonProperty(value="domain") String domain, @JacksonInject(value="ip_address") @JsonProperty(value="ip_address") String ipAddress, @JsonProperty(value="is_anonymous") boolean isAnonymous, @JsonProperty(value="is_anonymous_proxy") boolean isAnonymousProxy, @JsonProperty(value="is_anonymous_vpn") boolean isAnonymousVpn, @JsonProperty(value="is_anycast") boolean isAnycast, @JsonProperty(value="is_hosting_provider") boolean isHostingProvider, @JsonProperty(value="is_legitimate_proxy") boolean isLegitimateProxy, @JsonProperty(value="is_public_proxy") boolean isPublicProxy, @JsonProperty(value="is_residential_proxy") boolean isResidentialProxy, @JsonProperty(value="is_satellite_provider") boolean isSatelliteProvider, @JsonProperty(value="is_tor_exit_node") boolean isTorExitNode, @JsonProperty(value="isp") String isp, @JsonProperty(value="mobile_country_code") String mobileCountryCode, @JsonProperty(value="mobile_network_code") String mobileNetworkCode, @JacksonInject(value="network") @JsonProperty(value="network") @JsonDeserialize(using=NetworkDeserializer.class) Network network, @JsonProperty(value="organization") String organization, @JsonProperty(value="user_type") String userType, @JsonProperty(value="user_count") Integer userCount, @JsonProperty(value="static_ip_score") Double staticIpScore) {
        this.autonomousSystemNumber = autonomousSystemNumber;
        this.autonomousSystemOrganization = autonomousSystemOrganization;
        this.connectionType = connectionType;
        this.domain = domain;
        this.ipAddress = ipAddress;
        this.isAnonymous = isAnonymous;
        this.isAnonymousProxy = isAnonymousProxy;
        this.isAnonymousVpn = isAnonymousVpn;
        this.isAnycast = isAnycast;
        this.isHostingProvider = isHostingProvider;
        this.isLegitimateProxy = isLegitimateProxy;
        this.isPublicProxy = isPublicProxy;
        this.isResidentialProxy = isResidentialProxy;
        this.isSatelliteProvider = isSatelliteProvider;
        this.isTorExitNode = isTorExitNode;
        this.isp = isp;
        this.mobileCountryCode = mobileCountryCode;
        this.mobileNetworkCode = mobileNetworkCode;
        this.network = network;
        this.organization = organization;
        this.userType = userType;
        this.userCount = userCount;
        this.staticIpScore = staticIpScore;
    }

    @MaxMindDbConstructor
    public Traits(@MaxMindDbParameter(name="autonomous_system_number") Long autonomousSystemNumber, @MaxMindDbParameter(name="autonomous_system_organization") String autonomousSystemOrganization, @MaxMindDbParameter(name="connection_type") String connectionType, @MaxMindDbParameter(name="domain") String domain, @MaxMindDbParameter(name="ip_address") String ipAddress, @MaxMindDbParameter(name="is_anonymous") Boolean isAnonymous, @MaxMindDbParameter(name="is_anonymous_proxy") Boolean isAnonymousProxy, @MaxMindDbParameter(name="is_anonymous_vpn") Boolean isAnonymousVpn, @MaxMindDbParameter(name="is_anycast") Boolean isAnycast, @MaxMindDbParameter(name="is_hosting_provider") Boolean isHostingProvider, @MaxMindDbParameter(name="is_legitimate_proxy") Boolean isLegitimateProxy, @MaxMindDbParameter(name="is_public_proxy") Boolean isPublicProxy, @MaxMindDbParameter(name="is_residential_proxy") Boolean isResidentialProxy, @MaxMindDbParameter(name="is_satellite_provider") Boolean isSatelliteProvider, @MaxMindDbParameter(name="is_tor_exit_node") Boolean isTorExitNode, @MaxMindDbParameter(name="isp") String isp, @MaxMindDbParameter(name="mobile_country_code") String mobileCountryCode, @MaxMindDbParameter(name="mobile_network_code") String mobileNetworkCode, @MaxMindDbParameter(name="network") Network network, @MaxMindDbParameter(name="organization") String organization, @MaxMindDbParameter(name="user_type") String userType, @MaxMindDbParameter(name="user_count") Integer userCount, @MaxMindDbParameter(name="static_ip_score") Double staticIpScore) {
        this.autonomousSystemNumber = autonomousSystemNumber;
        this.autonomousSystemOrganization = autonomousSystemOrganization;
        this.connectionType = ConnectionTypeResponse.ConnectionType.fromString(connectionType);
        this.domain = domain;
        this.ipAddress = ipAddress;
        this.isAnonymous = isAnonymous != null ? isAnonymous : false;
        this.isAnonymousProxy = isAnonymousProxy != null ? isAnonymousProxy : false;
        this.isAnonymousVpn = isAnonymousVpn != null ? isAnonymousVpn : false;
        this.isAnycast = isAnycast != null ? isAnycast : false;
        this.isHostingProvider = isHostingProvider != null ? isHostingProvider : false;
        this.isLegitimateProxy = isLegitimateProxy != null ? isLegitimateProxy : false;
        this.isPublicProxy = isPublicProxy != null ? isPublicProxy : false;
        this.isResidentialProxy = isResidentialProxy != null ? isResidentialProxy : false;
        this.isSatelliteProvider = isSatelliteProvider != null ? isSatelliteProvider : false;
        this.isTorExitNode = isTorExitNode != null ? isTorExitNode : false;
        this.isp = isp;
        this.mobileCountryCode = mobileCountryCode;
        this.mobileNetworkCode = mobileNetworkCode;
        this.network = network;
        this.organization = organization;
        this.userType = userType;
        this.userCount = userCount;
        this.staticIpScore = staticIpScore;
    }

    @Deprecated
    public Traits(Long autonomousSystemNumber, String autonomousSystemOrganization, ConnectionTypeResponse.ConnectionType connectionType, String domain, String ipAddress, boolean isAnonymous, boolean isAnonymousProxy, boolean isAnonymousVpn, boolean isHostingProvider, boolean isLegitimateProxy, boolean isPublicProxy, boolean isResidentialProxy, boolean isSatelliteProvider, boolean isTorExitNode, String isp, String mobileCountryCode, String mobileNetworkCode, Network network, String organization, String userType, Integer userCount, Double staticIpScore) {
        this(autonomousSystemNumber, autonomousSystemOrganization, connectionType, domain, ipAddress, isAnonymous, isAnonymousProxy, isAnonymousVpn, false, isHostingProvider, isLegitimateProxy, isPublicProxy, isResidentialProxy, isSatelliteProvider, isTorExitNode, isp, mobileCountryCode, mobileNetworkCode, network, organization, userType, userCount, staticIpScore);
    }

    @Deprecated
    public Traits(Long autonomousSystemNumber, String autonomousSystemOrganization, String connectionType, String domain, String ipAddress, Boolean isAnonymous, Boolean isAnonymousProxy, Boolean isAnonymousVpn, Boolean isHostingProvider, Boolean isLegitimateProxy, Boolean isPublicProxy, Boolean isResidentialProxy, Boolean isSatelliteProvider, Boolean isTorExitNode, String isp, String mobileCountryCode, String mobileNetworkCode, Network network, String organization, String userType, Integer userCount, Double staticIpScore) {
        this(autonomousSystemNumber, autonomousSystemOrganization, connectionType, domain, ipAddress, isAnonymous, isAnonymousProxy, isAnonymousVpn, (Boolean)false, isHostingProvider, isLegitimateProxy, isPublicProxy, isResidentialProxy, isSatelliteProvider, isTorExitNode, isp, mobileCountryCode, mobileNetworkCode, network, organization, userType, userCount, staticIpScore);
    }

    public Traits(Traits traits, String ipAddress, Network network) {
        this(traits.getAutonomousSystemNumber(), traits.getAutonomousSystemOrganization(), traits.getConnectionType(), traits.getDomain(), ipAddress, traits.isAnonymous(), traits.isAnonymousProxy(), traits.isAnonymousVpn(), traits.isAnycast(), traits.isHostingProvider(), traits.isLegitimateProxy(), traits.isPublicProxy(), traits.isResidentialProxy(), traits.isSatelliteProvider(), traits.isTorExitNode(), traits.getIsp(), traits.getMobileCountryCode(), traits.getMobileNetworkCode(), network, traits.getOrganization(), traits.getUserType(), traits.getUserCount(), traits.getStaticIpScore());
    }

    @JsonProperty(value="autonomous_system_number")
    public Long getAutonomousSystemNumber() {
        return this.autonomousSystemNumber;
    }

    @JsonProperty(value="autonomous_system_organization")
    public String getAutonomousSystemOrganization() {
        return this.autonomousSystemOrganization;
    }

    @JsonProperty(value="connection_type")
    public ConnectionTypeResponse.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @JsonProperty(value="static_ip_score")
    public Double getStaticIpScore() {
        return this.staticIpScore;
    }

    @JsonProperty(value="user_count")
    public Integer getUserCount() {
        return this.userCount;
    }

    @JsonProperty
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="ip_address")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getIsp() {
        return this.isp;
    }

    @JsonProperty(value="is_anonymous")
    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    @Deprecated
    @JsonProperty(value="is_anonymous_proxy")
    public boolean isAnonymousProxy() {
        return this.isAnonymousProxy;
    }

    @JsonProperty(value="is_anonymous_vpn")
    public boolean isAnonymousVpn() {
        return this.isAnonymousVpn;
    }

    @JsonProperty(value="is_anycast")
    public boolean isAnycast() {
        return this.isAnycast;
    }

    @JsonProperty(value="is_hosting_provider")
    public boolean isHostingProvider() {
        return this.isHostingProvider;
    }

    @JsonProperty(value="is_legitimate_proxy")
    public boolean isLegitimateProxy() {
        return this.isLegitimateProxy;
    }

    @JsonProperty(value="is_public_proxy")
    public boolean isPublicProxy() {
        return this.isPublicProxy;
    }

    @JsonProperty(value="is_residential_proxy")
    public boolean isResidentialProxy() {
        return this.isResidentialProxy;
    }

    @Deprecated
    @JsonProperty(value="is_satellite_provider")
    public boolean isSatelliteProvider() {
        return this.isSatelliteProvider;
    }

    @JsonProperty(value="is_tor_exit_node")
    public boolean isTorExitNode() {
        return this.isTorExitNode;
    }

    @JsonProperty(value="mobile_country_code")
    public String getMobileCountryCode() {
        return this.mobileCountryCode;
    }

    @JsonProperty(value="mobile_network_code")
    public String getMobileNetworkCode() {
        return this.mobileNetworkCode;
    }

    @JsonProperty
    @JsonSerialize(using=ToStringSerializer.class)
    public Network getNetwork() {
        return this.network;
    }

    @JsonProperty
    public String getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="user_type")
    public String getUserType() {
        return this.userType;
    }
}

