/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.VectorScorer;

public class DenormalizedCosineFloatVectorValues
extends FloatVectorValues {
    private final FloatVectorValues in;
    private final NumericDocValues magnitudeIn;
    private final float[] vector;
    private float magnitude = 1.0f;
    private boolean hasMagnitude;
    private int docId = -1;

    public DenormalizedCosineFloatVectorValues(FloatVectorValues in, NumericDocValues magnitudeIn) {
        this.in = in;
        this.magnitudeIn = magnitudeIn;
        this.vector = new float[in.dimension()];
    }

    @Override
    public int dimension() {
        return this.in.dimension();
    }

    @Override
    public int size() {
        return this.in.size();
    }

    @Override
    public KnnVectorValues.DocIndexIterator iterator() {
        return this.in.iterator();
    }

    @Override
    public FloatVectorValues copy() throws IOException {
        return this.in.copy();
    }

    @Override
    public VectorScorer scorer(float[] floats) throws IOException {
        return this.in.scorer(floats);
    }

    public float magnitude() {
        return this.magnitude;
    }

    @Override
    public float[] vectorValue(int ord) throws IOException {
        int docId = this.ordToDoc(ord);
        if (docId != this.docId) {
            this.docId = docId;
            this.hasMagnitude = this.decodedMagnitude(docId);
            if (this.hasMagnitude) {
                System.arraycopy(this.in.vectorValue(ord), 0, this.vector, 0, this.dimension());
                int i = 0;
                while (i < this.vector.length) {
                    int n = i++;
                    this.vector[n] = this.vector[n] * this.magnitude;
                }
                return this.vector;
            }
            return this.in.vectorValue(ord);
        }
        return this.hasMagnitude ? this.vector : this.in.vectorValue(ord);
    }

    private boolean decodedMagnitude(int docId) throws IOException {
        if (this.magnitudeIn == null) {
            return false;
        }
        int currentDoc = this.magnitudeIn.docID();
        if (docId == currentDoc) {
            return true;
        }
        if (this.magnitudeIn.advanceExact(docId)) {
            this.magnitude = Float.intBitsToFloat((int)this.magnitudeIn.longValue());
            return true;
        }
        this.magnitude = 1.0f;
        return false;
    }
}

