/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ClusterFileSystem
implements JsonpSerializable {
    private final long availableInBytes;
    private final long freeInBytes;
    private final long totalInBytes;
    public static final JsonpDeserializer<ClusterFileSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterFileSystem::setupClusterFileSystemDeserializer);

    private ClusterFileSystem(Builder builder) {
        this.availableInBytes = ApiTypeHelper.requireNonNull(builder.availableInBytes, (Object)this, "availableInBytes", 0L);
        this.freeInBytes = ApiTypeHelper.requireNonNull(builder.freeInBytes, (Object)this, "freeInBytes", 0L);
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, (Object)this, "totalInBytes", 0L);
    }

    public static ClusterFileSystem of(Function<Builder, ObjectBuilder<ClusterFileSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long availableInBytes() {
        return this.availableInBytes;
    }

    public final long freeInBytes() {
        return this.freeInBytes;
    }

    public final long totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available_in_bytes");
        generator.write(this.availableInBytes);
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupClusterFileSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes");
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterFileSystem> {
        private Long availableInBytes;
        private Long freeInBytes;
        private Long totalInBytes;

        public final Builder availableInBytes(long value) {
            this.availableInBytes = value;
            return this;
        }

        public final Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public final Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterFileSystem build() {
            this._checkSingleUse();
            return new ClusterFileSystem(this);
        }
    }
}

