/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;

public class TransformCheckpointingInfo
implements Writeable,
ToXContentObject {
    public static final TransformCheckpointingInfo EMPTY = new TransformCheckpointingInfo(TransformCheckpointStats.EMPTY, TransformCheckpointStats.EMPTY, 0L, null, null);
    public static final String LAST_CHECKPOINT = "last";
    public static final String NEXT_CHECKPOINT = "next";
    public static final String OPERATIONS_BEHIND = "operations_behind";
    public static final String CHANGES_LAST_DETECTED_AT = "changes_last_detected_at";
    public static final String CHANGES_LAST_DETECTED_AT_HUMAN = "changes_last_detected_at_string";
    public static final String LAST_SEARCH_TIME = "last_search_time";
    public static final String LAST_SEARCH_TIME_HUMAN = "last_search_time_string";
    private final TransformCheckpointStats last;
    private final TransformCheckpointStats next;
    private final long operationsBehind;
    private final Instant changesLastDetectedAt;
    private final Instant lastSearchTime;

    public TransformCheckpointingInfo(TransformCheckpointStats last, TransformCheckpointStats next, long operationsBehind, Instant changesLastDetectedAt, Instant lastSearchTime) {
        this.last = Objects.requireNonNull(last);
        this.next = Objects.requireNonNull(next);
        this.operationsBehind = operationsBehind;
        this.changesLastDetectedAt = changesLastDetectedAt;
        this.lastSearchTime = lastSearchTime;
    }

    public TransformCheckpointingInfo(StreamInput in) throws IOException {
        this.last = new TransformCheckpointStats(in);
        this.next = new TransformCheckpointStats(in);
        this.operationsBehind = in.readLong();
        this.changesLastDetectedAt = in.readOptionalInstant();
        this.lastSearchTime = in.readOptionalInstant();
    }

    public TransformCheckpointStats getLast() {
        return this.last;
    }

    public TransformCheckpointStats getNext() {
        return this.next;
    }

    public long getOperationsBehind() {
        return this.operationsBehind;
    }

    public Instant getChangesLastDetectedAt() {
        return this.changesLastDetectedAt;
    }

    public Instant getLastSearchTime() {
        return this.lastSearchTime;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LAST_CHECKPOINT, this.last);
        if (this.next.getCheckpoint() > 0L) {
            builder.field(NEXT_CHECKPOINT, this.next);
        }
        if (this.operationsBehind > 0L) {
            builder.field(OPERATIONS_BEHIND, this.operationsBehind);
        }
        if (this.changesLastDetectedAt != null) {
            builder.timestampFieldsFromUnixEpochMillis(CHANGES_LAST_DETECTED_AT, CHANGES_LAST_DETECTED_AT_HUMAN, this.changesLastDetectedAt.toEpochMilli());
        }
        if (this.lastSearchTime != null) {
            builder.timestampFieldsFromUnixEpochMillis(LAST_SEARCH_TIME, LAST_SEARCH_TIME_HUMAN, this.lastSearchTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.last.writeTo(out);
        this.next.writeTo(out);
        out.writeLong(this.operationsBehind);
        out.writeOptionalInstant(this.changesLastDetectedAt);
        out.writeOptionalInstant(this.lastSearchTime);
    }

    public int hashCode() {
        return Objects.hash(this.last, this.next, this.operationsBehind, this.changesLastDetectedAt, this.lastSearchTime);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformCheckpointingInfo that = (TransformCheckpointingInfo)other;
        return Objects.equals(this.last, that.last) && Objects.equals(this.next, that.next) && this.operationsBehind == that.operationsBehind && Objects.equals(this.changesLastDetectedAt, that.changesLastDetectedAt) && Objects.equals(this.lastSearchTime, that.lastSearchTime);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public static class TransformCheckpointingInfoBuilder {
        private TransformIndexerPosition nextCheckpointPosition;
        private TransformProgress nextCheckpointProgress;
        private TransformCheckpoint lastCheckpoint;
        private TransformCheckpoint nextCheckpoint;
        private TransformCheckpoint sourceCheckpoint;
        private Instant changesLastDetectedAt;
        private Instant lastSearchTime;
        private long operationsBehind;

        public TransformCheckpointingInfo build() {
            if (this.lastCheckpoint == null) {
                this.lastCheckpoint = TransformCheckpoint.EMPTY;
            }
            if (this.nextCheckpoint == null) {
                this.nextCheckpoint = TransformCheckpoint.EMPTY;
            }
            if (this.sourceCheckpoint == null) {
                this.sourceCheckpoint = TransformCheckpoint.EMPTY;
            }
            long lastCheckpointNumber = this.lastCheckpoint.getCheckpoint() > 0L ? this.lastCheckpoint.getCheckpoint() : 0L;
            long nextCheckpointNumber = this.nextCheckpoint.getCheckpoint() > 0L ? this.nextCheckpoint.getCheckpoint() : 0L;
            return new TransformCheckpointingInfo(new TransformCheckpointStats(lastCheckpointNumber, null, null, this.lastCheckpoint.getTimestamp(), this.lastCheckpoint.getTimeUpperBound()), new TransformCheckpointStats(nextCheckpointNumber, this.nextCheckpointPosition, this.nextCheckpointProgress, this.nextCheckpoint.getTimestamp(), this.nextCheckpoint.getTimeUpperBound()), this.operationsBehind, this.changesLastDetectedAt, this.lastSearchTime);
        }

        public TransformCheckpointingInfoBuilder setLastCheckpoint(TransformCheckpoint lastCheckpoint) {
            this.lastCheckpoint = lastCheckpoint;
            return this;
        }

        public TransformCheckpoint getLastCheckpoint() {
            return this.lastCheckpoint;
        }

        public TransformCheckpointingInfoBuilder setNextCheckpoint(TransformCheckpoint nextCheckpoint) {
            this.nextCheckpoint = nextCheckpoint;
            return this;
        }

        public TransformCheckpoint getNextCheckpoint() {
            return this.nextCheckpoint;
        }

        public TransformCheckpointingInfoBuilder setSourceCheckpoint(TransformCheckpoint sourceCheckpoint) {
            this.sourceCheckpoint = sourceCheckpoint;
            return this;
        }

        public TransformCheckpoint getSourceCheckpoint() {
            return this.sourceCheckpoint;
        }

        public TransformCheckpointingInfoBuilder setNextCheckpointProgress(TransformProgress nextCheckpointProgress) {
            this.nextCheckpointProgress = nextCheckpointProgress;
            return this;
        }

        public TransformCheckpointingInfoBuilder setNextCheckpointPosition(TransformIndexerPosition nextCheckpointPosition) {
            this.nextCheckpointPosition = nextCheckpointPosition;
            return this;
        }

        public TransformCheckpointingInfoBuilder setChangesLastDetectedAt(Instant changesLastDetectedAt) {
            this.changesLastDetectedAt = changesLastDetectedAt;
            return this;
        }

        public TransformCheckpointingInfoBuilder setLastSearchTime(Instant lastSearchTime) {
            this.lastSearchTime = lastSearchTime;
            return this;
        }

        public TransformCheckpointingInfoBuilder setOperationsBehind(long operationsBehind) {
            this.operationsBehind = operationsBehind;
            return this;
        }
    }
}

