/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.saml;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;

public final class SamlCompleteLogoutRequest
extends LegacyActionRequest {
    @Nullable
    private String queryString;
    @Nullable
    private String content;
    private List<String> validRequestIds;
    private String realm;

    public SamlCompleteLogoutRequest(StreamInput in) throws IOException {
        super(in);
    }

    public SamlCompleteLogoutRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Strings.hasText(this.realm)) {
            validationException = ValidateActions.addValidationError("realm may not be empty", validationException);
        }
        if (!Strings.hasText(this.queryString) && !Strings.hasText(this.content)) {
            validationException = ValidateActions.addValidationError("query_string and content may not both be empty", validationException);
        }
        if (Strings.hasText(this.queryString) && Strings.hasText(this.content)) {
            validationException = ValidateActions.addValidationError("query_string and content may not both present", validationException);
        }
        return validationException;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        if (this.queryString != null) {
            throw new IllegalArgumentException("Must use either [query_string] or [queryString], not both at the same time");
        }
        this.queryString = queryString;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<String> getValidRequestIds() {
        return this.validRequestIds;
    }

    public void setValidRequestIds(List<String> validRequestIds) {
        this.validRequestIds = validRequestIds;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean isHttpRedirect() {
        return this.queryString != null;
    }

    public String getPayload() {
        return this.isHttpRedirect() ? this.queryString : this.content;
    }
}

