/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.FeatureImportanceBaseline;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.Hyperparameters;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata.TotalFeatureImportance;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TrainedModelMetadata
implements ToXContentObject,
Writeable {
    public static final String NAME = "trained_model_metadata";
    public static final ParseField TOTAL_FEATURE_IMPORTANCE = new ParseField("total_feature_importance", new String[0]);
    public static final ParseField HYPERPARAMETERS = new ParseField("hyperparameters", new String[0]);
    public static final ParseField FEATURE_IMPORTANCE_BASELINE = new ParseField("feature_importance_baseline", new String[0]);
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ConstructingObjectParser<TrainedModelMetadata, Void> LENIENT_PARSER = TrainedModelMetadata.createParser(true);
    public static final ConstructingObjectParser<TrainedModelMetadata, Void> STRICT_PARSER = TrainedModelMetadata.createParser(false);
    private final List<TotalFeatureImportance> totalFeatureImportances;
    private final FeatureImportanceBaseline featureImportanceBaselines;
    private final List<Hyperparameters> hyperparameters;
    private final String modelId;

    private static ConstructingObjectParser<TrainedModelMetadata, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<TrainedModelMetadata, Void> parser = new ConstructingObjectParser<TrainedModelMetadata, Void>(NAME, ignoreUnknownFields, a -> new TrainedModelMetadata((String)a[0], (List)a[1], (FeatureImportanceBaseline)a[2], (List)a[3]));
        parser.declareString(ConstructingObjectParser.constructorArg(), MODEL_ID);
        parser.declareObjectArray(ConstructingObjectParser.constructorArg(), ignoreUnknownFields ? TotalFeatureImportance.LENIENT_PARSER : TotalFeatureImportance.STRICT_PARSER, TOTAL_FEATURE_IMPORTANCE);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), ignoreUnknownFields ? FeatureImportanceBaseline.LENIENT_PARSER : FeatureImportanceBaseline.STRICT_PARSER, FEATURE_IMPORTANCE_BASELINE);
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), ignoreUnknownFields ? Hyperparameters.LENIENT_PARSER : Hyperparameters.STRICT_PARSER, HYPERPARAMETERS);
        return parser;
    }

    public static TrainedModelMetadata fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? LENIENT_PARSER.parse(parser, null) : STRICT_PARSER.parse(parser, null);
    }

    public static String docId(String modelId) {
        return "trained_model_metadata-" + modelId;
    }

    public static String modelId(String docId) {
        return docId.substring(NAME.length() + 1);
    }

    public TrainedModelMetadata(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.totalFeatureImportances = in.readCollectionAsList(TotalFeatureImportance::new);
        this.featureImportanceBaselines = in.readOptionalWriteable(FeatureImportanceBaseline::new);
        this.hyperparameters = in.readCollectionAsList(Hyperparameters::new);
    }

    public TrainedModelMetadata(String modelId, List<TotalFeatureImportance> totalFeatureImportances, FeatureImportanceBaseline featureImportanceBaselines, List<Hyperparameters> hyperparameters) {
        this.modelId = ExceptionsHelper.requireNonNull(modelId, MODEL_ID);
        this.totalFeatureImportances = Collections.unmodifiableList(totalFeatureImportances);
        this.featureImportanceBaselines = featureImportanceBaselines;
        this.hyperparameters = hyperparameters == null ? Collections.emptyList() : Collections.unmodifiableList(hyperparameters);
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDocId() {
        return TrainedModelMetadata.docId(this.modelId);
    }

    public List<TotalFeatureImportance> getTotalFeatureImportances() {
        return this.totalFeatureImportances;
    }

    public FeatureImportanceBaseline getFeatureImportanceBaselines() {
        return this.featureImportanceBaselines;
    }

    public List<Hyperparameters> getHyperparameters() {
        return this.hyperparameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelMetadata that = (TrainedModelMetadata)o;
        return Objects.equals(this.totalFeatureImportances, that.totalFeatureImportances) && Objects.equals(this.featureImportanceBaselines, that.featureImportanceBaselines) && Objects.equals(this.hyperparameters, that.hyperparameters) && Objects.equals(this.modelId, that.modelId);
    }

    public int hashCode() {
        return Objects.hash(this.totalFeatureImportances, this.featureImportanceBaselines, this.hyperparameters, this.modelId);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeCollection(this.totalFeatureImportances);
        out.writeOptionalWriteable(this.featureImportanceBaselines);
        out.writeCollection(this.hyperparameters);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(InferenceIndexConstants.DOC_TYPE.getPreferredName(), NAME);
        }
        builder.field(MODEL_ID.getPreferredName(), this.modelId);
        builder.field(TOTAL_FEATURE_IMPORTANCE.getPreferredName(), (Iterable<?>)this.totalFeatureImportances);
        if (this.featureImportanceBaselines != null) {
            builder.field(FEATURE_IMPORTANCE_BASELINE.getPreferredName(), this.featureImportanceBaselines);
        }
        builder.field(HYPERPARAMETERS.getPreferredName(), (Iterable<?>)this.hyperparameters);
        builder.endObject();
        return builder;
    }
}

