/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestoreInfo
implements ToXContentObject,
Writeable {
    private final String name;
    private final List<String> indices;
    private final int totalShards;
    private final int successfulShards;

    public RestoreInfo(String name, List<String> indices, int totalShards, int successfulShards) {
        this.name = name;
        this.indices = indices;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
    }

    public RestoreInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.indices = in.readStringCollectionAsImmutableList();
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
    }

    public String name() {
        return this.name;
    }

    public List<String> indices() {
        return this.indices;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("snapshot", this.name);
        builder.startArray("indices");
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.startObject("shards");
        builder.field("total", this.totalShards);
        builder.field("failed", this.failedShards());
        builder.field("successful", this.successfulShards);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.indices);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreInfo that = (RestoreInfo)o;
        return this.totalShards == that.totalShards && this.successfulShards == that.successfulShards && Objects.equals(this.name, that.name) && Objects.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.indices, this.totalShards, this.successfulShards);
    }

    public String toString() {
        return Strings.toString(this);
    }
}

