/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.function.DoubleSupplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.MergePolicy;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;

public class MergeTracking {
    protected final Logger logger;
    private final DoubleSupplier mbPerSecAutoThrottle;
    private final MeanMetric totalMerges = new MeanMetric();
    private final CounterMetric totalMergesNumDocs = new CounterMetric();
    private final CounterMetric totalMergesSizeInBytes = new CounterMetric();
    private final CounterMetric currentMerges = new CounterMetric();
    private final CounterMetric currentMergesNumDocs = new CounterMetric();
    private final CounterMetric currentMergesSizeInBytes = new CounterMetric();
    private final CounterMetric totalMergeStoppedTime = new CounterMetric();
    private final CounterMetric totalMergeThrottledTime = new CounterMetric();
    private final Set<OnGoingMerge> onGoingMerges = ConcurrentCollections.newConcurrentSet();
    private final Set<OnGoingMerge> readOnlyOnGoingMerges = Collections.unmodifiableSet(this.onGoingMerges);

    public MergeTracking(Logger logger, DoubleSupplier mbPerSecAutoThrottle) {
        this.logger = logger;
        this.mbPerSecAutoThrottle = mbPerSecAutoThrottle;
    }

    public Set<OnGoingMerge> onGoingMerges() {
        return this.readOnlyOnGoingMerges;
    }

    public void mergeStarted(OnGoingMerge onGoingMerge) {
        MergePolicy.OneMerge merge = onGoingMerge.getMerge();
        int totalNumDocs = merge.totalNumDocs();
        long totalSizeInBytes = merge.totalBytesSize();
        this.currentMerges.inc();
        this.currentMergesNumDocs.inc(totalNumDocs);
        this.currentMergesSizeInBytes.inc(totalSizeInBytes);
        this.onGoingMerges.add(onGoingMerge);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("merge [{}] starting: merging [{}] segments, [{}] docs, [{}] size, into [{}] estimated_size", (Object)onGoingMerge.getId(), (Object)merge.segments.size(), (Object)totalNumDocs, (Object)ByteSizeValue.ofBytes(totalSizeInBytes), (Object)ByteSizeValue.ofBytes(merge.estimatedMergeBytes));
        }
    }

    public void mergeFinished(MergePolicy.OneMerge merge, OnGoingMerge onGoingMerge, long tookMS) {
        int totalNumDocs = merge.totalNumDocs();
        long totalSizeInBytes = merge.totalBytesSize();
        this.onGoingMerges.remove(onGoingMerge);
        this.currentMerges.dec();
        this.currentMergesNumDocs.dec(totalNumDocs);
        this.currentMergesSizeInBytes.dec(totalSizeInBytes);
        this.totalMergesNumDocs.inc(totalNumDocs);
        this.totalMergesSizeInBytes.inc(totalSizeInBytes);
        this.totalMerges.inc(tookMS);
        long stoppedMS = TimeValue.nsecToMSec(merge.getMergeProgress().getPauseTimes().get((Object)MergePolicy.OneMergeProgress.PauseReason.STOPPED));
        long throttledMS = TimeValue.nsecToMSec(merge.getMergeProgress().getPauseTimes().get((Object)MergePolicy.OneMergeProgress.PauseReason.PAUSED));
        this.totalMergeStoppedTime.inc(stoppedMS);
        this.totalMergeThrottledTime.inc(throttledMS);
        String message = String.format(Locale.ROOT, "merge [%s] segment [%s] done: took [%s], [%s], [%,d] docs, [%s] stopped, [%s] throttled", onGoingMerge.getId(), MergeTracking.getSegmentName(merge), TimeValue.timeValueMillis(tookMS), ByteSizeValue.ofBytes(totalSizeInBytes), totalNumDocs, TimeValue.timeValueMillis(stoppedMS), TimeValue.timeValueMillis(throttledMS));
        if (tookMS > 20000L) {
            this.logger.debug("{}", (Object)message);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("{}", (Object)message);
        }
    }

    public MergeStats stats() {
        MergeStats mergeStats = new MergeStats();
        mergeStats.add(this.totalMerges.count(), this.totalMerges.sum(), this.totalMergesNumDocs.count(), this.totalMergesSizeInBytes.count(), this.currentMerges.count(), this.currentMergesNumDocs.count(), this.currentMergesSizeInBytes.count(), this.totalMergeStoppedTime.count(), this.totalMergeThrottledTime.count(), this.mbPerSecAutoThrottle.getAsDouble());
        return mergeStats;
    }

    private static String getSegmentName(MergePolicy.OneMerge merge) {
        return merge.getMergeInfo() != null ? merge.getMergeInfo().info.name : "_na_";
    }
}

