/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Streams;

public abstract class BytesStream
extends StreamOutput {
    @Override
    public void writeWithSizePrefix(Writeable writeable) throws IOException {
        long pos = this.position();
        this.seek(pos + 4L);
        try (OutputStreamStreamOutput out = new OutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(Streams.noCloseStream(this)));){
            out.setTransportVersion(this.getTransportVersion());
            writeable.writeTo(out);
        }
        long newPos = this.position();
        this.seek(pos);
        this.writeInt(Math.toIntExact(newPos - pos - 4L));
        this.seek(newPos);
    }

    public abstract BytesReference bytes();

    public abstract void seek(long var1);
}

