/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class TransformHealthIssue
implements Writeable,
ToXContentObject {
    private static final String TYPE = "type";
    private static final String ISSUE = "issue";
    private static final String DETAILS = "details";
    private static final String COUNT = "count";
    private static final String FIRST_OCCURRENCE = "first_occurrence";
    private static final String FIRST_OCCURRENCE_HUMAN_READABLE = "first_occurrence_string";
    private static final String DEFAULT_TYPE_PRE_8_8 = "unknown";
    private final String type;
    private final String issue;
    private final String details;
    private final int count;
    private final Instant firstOccurrence;

    public TransformHealthIssue(String type, String issue, String details, int count, Instant firstOccurrence) {
        this.type = Objects.requireNonNull(type);
        this.issue = Objects.requireNonNull(issue);
        this.details = details;
        if (count < 1) {
            throw new IllegalArgumentException("[count] must be at least 1, got: " + count);
        }
        this.count = count;
        this.firstOccurrence = firstOccurrence != null ? firstOccurrence.truncatedTo(ChronoUnit.MILLIS) : null;
    }

    public TransformHealthIssue(StreamInput in) throws IOException {
        this.type = in.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0) ? in.readString() : DEFAULT_TYPE_PRE_8_8;
        this.issue = in.readString();
        this.details = in.readOptionalString();
        this.count = in.readVInt();
        this.firstOccurrence = in.readOptionalInstant();
    }

    public String getType() {
        return this.type;
    }

    public String getIssue() {
        return this.issue;
    }

    public String getDetails() {
        return this.details;
    }

    public int getCount() {
        return this.count;
    }

    public Instant getFirstOccurrence() {
        return this.firstOccurrence;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE, this.type);
        builder.field(ISSUE, this.issue);
        if (!Strings.isNullOrEmpty(this.details)) {
            builder.field(DETAILS, this.details);
        }
        builder.field(COUNT, this.count);
        if (this.firstOccurrence != null) {
            builder.timestampFieldsFromUnixEpochMillis(FIRST_OCCURRENCE, FIRST_OCCURRENCE_HUMAN_READABLE, this.firstOccurrence.toEpochMilli());
        }
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_8_0)) {
            out.writeString(this.type);
        }
        out.writeString(this.issue);
        out.writeOptionalString(this.details);
        out.writeVInt(this.count);
        out.writeOptionalInstant(this.firstOccurrence);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformHealthIssue that = (TransformHealthIssue)other;
        return this.count == that.count && Objects.equals(this.type, that.type) && Objects.equals(this.issue, that.issue) && Objects.equals(this.details, that.details) && Objects.equals(this.firstOccurrence, that.firstOccurrence);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.issue, this.details, this.count, this.firstOccurrence);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

