/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl.action;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.ssl.action.GetCertificateInfoAction;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

public class TransportGetCertificateInfoAction
extends HandledTransportAction<GetCertificateInfoAction.Request, GetCertificateInfoAction.Response> {
    private final SSLService sslService;

    @Inject
    public TransportGetCertificateInfoAction(TransportService transportService, ActionFilters actionFilters, SSLService sslService) {
        super("cluster:monitor/xpack/ssl/certificates/get", transportService, actionFilters, GetCertificateInfoAction.Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.sslService = sslService;
    }

    @Override
    protected void doExecute(Task task, GetCertificateInfoAction.Request request, ActionListener<GetCertificateInfoAction.Response> listener) {
        try {
            Collection<CertificateInfo> certificates = this.sslService.getLoadedCertificates();
            listener.onResponse(new GetCertificateInfoAction.Response(certificates));
        }
        catch (IOException | GeneralSecurityException e) {
            listener.onFailure(e);
        }
    }
}

