/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.ccr.action.PauseFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ShardFollowTask;
import org.elasticsearch.xpack.core.ilm.AbstractUnfollowIndexStep;
import org.elasticsearch.xpack.core.ilm.Step;

final class PauseFollowerIndexStep
extends AbstractUnfollowIndexStep {
    static final String NAME = "pause-follower-index";

    PauseFollowerIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void innerPerformAction(String followerIndex, ProjectState currentState, ActionListener<Void> listener) {
        PersistentTasksCustomMetadata persistentTasksMetadata = (PersistentTasksCustomMetadata)currentState.metadata().custom("persistent_tasks");
        if (persistentTasksMetadata == null) {
            listener.onResponse(null);
            return;
        }
        List<PersistentTasksCustomMetadata.PersistentTask> shardFollowTasks = persistentTasksMetadata.tasks().stream().filter(persistentTask -> "xpack/ccr/shard_follow_task".equals(persistentTask.getTaskName())).filter(persistentTask -> {
            ShardFollowTask shardFollowTask = (ShardFollowTask)persistentTask.getParams();
            return shardFollowTask.getFollowShardId().getIndexName().equals(followerIndex);
        }).toList();
        if (shardFollowTasks.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        PauseFollowAction.Request request = new PauseFollowAction.Request(TimeValue.MAX_VALUE, followerIndex);
        this.getClient(currentState.projectId()).execute(PauseFollowAction.INSTANCE, request, listener.delegateFailureAndWrap((l, r) -> {
            if (!r.isAcknowledged()) {
                throw new ElasticsearchException("pause follow request failed to be acknowledged", new Object[0]);
            }
            l.onResponse(null);
        }));
    }
}

