/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.prefix;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.prefix.IpPrefixAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.prefix.IpPrefixAggregationSupplier;
import org.elasticsearch.search.aggregations.bucket.prefix.IpPrefixAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;

public class IpPrefixAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final boolean keyed;
    private final long minDocCount;
    private final IpPrefixAggregator.IpPrefix ipPrefix;
    private final IpPrefixAggregationSupplier aggregationSupplier;

    public IpPrefixAggregatorFactory(String name, ValuesSourceConfig config, boolean keyed, long minDocCount, IpPrefixAggregator.IpPrefix ipPrefix, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, IpPrefixAggregationSupplier aggregationSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.ipPrefix = ipPrefix;
        this.aggregationSupplier = aggregationSupplier;
    }

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(IpPrefixAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.IP, IpPrefixAggregator::new, true);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new IpPrefixAggregator.Unmapped(this.name, this.factories, this.config, this.keyed, this.minDocCount, this.context, parent, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregationSupplier.build(this.name, this.factories, this.config, this.keyed, this.minDocCount, this.ipPrefix, this.context, parent, cardinality, metadata);
    }
}

