/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.DateFormat;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public final class DateIndexNameProcessor
extends AbstractProcessor {
    public static final String TYPE = "date_index_name";
    private final String field;
    private final TemplateScript.Factory indexNamePrefixTemplate;
    private final TemplateScript.Factory dateRoundingTemplate;
    private final TemplateScript.Factory indexNameFormatTemplate;
    private final ZoneId timezone;
    private final List<Function<String, ZonedDateTime>> dateFormats;

    DateIndexNameProcessor(String tag, String description, String field, List<Function<String, ZonedDateTime>> dateFormats, ZoneId timezone, TemplateScript.Factory indexNamePrefixTemplate, TemplateScript.Factory dateRoundingTemplate, TemplateScript.Factory indexNameFormatTemplate) {
        super(tag, description);
        this.field = field;
        this.timezone = timezone;
        this.dateFormats = dateFormats;
        this.indexNamePrefixTemplate = indexNamePrefixTemplate;
        this.dateRoundingTemplate = dateRoundingTemplate;
        this.indexNameFormatTemplate = indexNameFormatTemplate;
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        Object obj = ingestDocument.getFieldValue(this.field, Object.class);
        String date = null;
        if (obj != null) {
            date = obj.toString();
        }
        ZonedDateTime dateTime = null;
        Exception lastException = null;
        for (Function<String, ZonedDateTime> dateParser : this.dateFormats) {
            try {
                dateTime = dateParser.apply(date);
            }
            catch (Exception e) {
                lastException = ExceptionsHelper.useOrSuppress(lastException, e);
            }
        }
        if (dateTime == null) {
            throw new IllegalArgumentException("unable to parse date [" + date + "]", lastException);
        }
        String indexNamePrefix = ingestDocument.renderTemplate(this.indexNamePrefixTemplate);
        String indexNameFormat = ingestDocument.renderTemplate(this.indexNameFormatTemplate);
        String dateRounding = ingestDocument.renderTemplate(this.dateRoundingTemplate);
        DateFormatter formatter = DateFormatter.forPattern(indexNameFormat);
        String zone = this.timezone.equals(ZoneOffset.UTC) ? "UTC" : this.timezone.getId();
        StringBuilder builder = new StringBuilder().append('<').append(indexNamePrefix).append('{').append(formatter.format(dateTime)).append("||/").append(dateRounding).append('{').append(indexNameFormat).append('|').append(zone).append('}').append('}').append('>');
        String dynamicIndexName = builder.toString();
        ingestDocument.setFieldValue(IngestDocument.Metadata.INDEX.getFieldName(), dynamicIndexName);
        return ingestDocument;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    TemplateScript.Factory getIndexNamePrefixTemplate() {
        return this.indexNamePrefixTemplate;
    }

    TemplateScript.Factory getDateRoundingTemplate() {
        return this.dateRoundingTemplate;
    }

    TemplateScript.Factory getIndexNameFormatTemplate() {
        return this.indexNameFormatTemplate;
    }

    ZoneId getTimezone() {
        return this.timezone;
    }

    List<Function<String, ZonedDateTime>> getDateFormats() {
        return this.dateFormats;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        @Override
        public DateIndexNameProcessor create(Map<String, Processor.Factory> registry, String tag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            List<Object> dateFormatStrings;
            String localeString = ConfigurationUtils.readOptionalStringProperty(DateIndexNameProcessor.TYPE, tag, config, "locale");
            String timezoneString = ConfigurationUtils.readOptionalStringProperty(DateIndexNameProcessor.TYPE, tag, config, "timezone");
            ZoneId timezone = timezoneString == null ? ZoneOffset.UTC : ZoneId.of(timezoneString);
            Locale locale = Locale.ENGLISH;
            if (localeString != null) {
                try {
                    locale = new Locale.Builder().setLanguageTag(localeString).build();
                }
                catch (IllformedLocaleException e) {
                    throw new IllegalArgumentException("Invalid language tag specified: " + localeString);
                }
            }
            if ((dateFormatStrings = ConfigurationUtils.readOptionalList(DateIndexNameProcessor.TYPE, tag, config, "date_formats")) == null) {
                dateFormatStrings = Collections.singletonList("yyyy-MM-dd'T'HH:mm:ss.SSSXX");
            }
            ArrayList<Function<String, ZonedDateTime>> dateFormats = new ArrayList<Function<String, ZonedDateTime>>(dateFormatStrings.size());
            for (String string : dateFormatStrings) {
                DateFormat dateFormat = DateFormat.fromString(string);
                dateFormats.add(dateFormat.getFunction(string, timezone, locale));
            }
            String field = ConfigurationUtils.readStringProperty(DateIndexNameProcessor.TYPE, tag, config, "field");
            String string = ConfigurationUtils.readStringProperty(DateIndexNameProcessor.TYPE, tag, config, "index_name_prefix", "");
            TemplateScript.Factory indexNamePrefixTemplate = ConfigurationUtils.compileTemplate(DateIndexNameProcessor.TYPE, tag, "index_name_prefix", string, this.scriptService);
            String dateRounding = ConfigurationUtils.readStringProperty(DateIndexNameProcessor.TYPE, tag, config, "date_rounding");
            TemplateScript.Factory dateRoundingTemplate = ConfigurationUtils.compileTemplate(DateIndexNameProcessor.TYPE, tag, "date_rounding", dateRounding, this.scriptService);
            String indexNameFormat = ConfigurationUtils.readStringProperty(DateIndexNameProcessor.TYPE, tag, config, "index_name_format", "yyyy-MM-dd");
            TemplateScript.Factory indexNameFormatTemplate = ConfigurationUtils.compileTemplate(DateIndexNameProcessor.TYPE, tag, "index_name_format", indexNameFormat, this.scriptService);
            return new DateIndexNameProcessor(tag, description, field, dateFormats, timezone, indexNamePrefixTemplate, dateRoundingTemplate, indexNameFormatTemplate);
        }
    }
}

