/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public record DataStreamGlobalRetention(@Nullable TimeValue defaultRetention, @Nullable TimeValue maxRetention) implements Writeable
{
    public static final TimeValue MIN_RETENTION_VALUE = TimeValue.timeValueSeconds(10L);

    public DataStreamGlobalRetention(TimeValue defaultRetention, TimeValue maxRetention) {
        if (defaultRetention != null && maxRetention != null && defaultRetention.getMillis() > maxRetention.getMillis()) {
            throw new IllegalArgumentException("Default global retention [" + defaultRetention.getStringRep() + "] cannot be greater than the max global retention [" + maxRetention.getStringRep() + "].");
        }
        if (!this.validateRetentionValue(defaultRetention) || !this.validateRetentionValue(maxRetention)) {
            throw new IllegalArgumentException("Global retention values should be greater than " + MIN_RETENTION_VALUE.getStringRep());
        }
        this.defaultRetention = defaultRetention;
        this.maxRetention = maxRetention;
    }

    @Nullable
    public static DataStreamGlobalRetention create(@Nullable TimeValue defaultRetention, @Nullable TimeValue maxRetention) {
        if (defaultRetention == null && maxRetention == null) {
            return null;
        }
        return new DataStreamGlobalRetention(defaultRetention, maxRetention);
    }

    private boolean validateRetentionValue(@Nullable TimeValue retention) {
        return retention == null || retention.getMillis() >= MIN_RETENTION_VALUE.getMillis();
    }

    public static DataStreamGlobalRetention read(StreamInput in) throws IOException {
        return new DataStreamGlobalRetention(in.readOptionalTimeValue(), in.readOptionalTimeValue());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalTimeValue(this.defaultRetention);
        out.writeOptionalTimeValue(this.maxRetention);
    }

    @Override
    public String toString() {
        return "DataStreamGlobalRetention{defaultRetention=" + (this.defaultRetention == null ? "null" : this.defaultRetention.getStringRep()) + ", maxRetention=" + (this.maxRetention == null ? "null" : this.maxRetention.getStringRep()) + "}";
    }
}

