/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.ml.JobStatistics;
import co.elastic.clients.elasticsearch.xpack.usage.MlJobForecasts;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class JobUsage
implements JsonpSerializable {
    private final int count;
    private final Map<String, Long> createdBy;
    private final JobStatistics detectors;
    private final MlJobForecasts forecasts;
    private final JobStatistics modelSize;
    public static final JsonpDeserializer<JobUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JobUsage::setupJobUsageDeserializer);

    private JobUsage(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.createdBy = ApiTypeHelper.unmodifiableRequired(builder.createdBy, (Object)this, "createdBy");
        this.detectors = ApiTypeHelper.requireNonNull(builder.detectors, this, "detectors");
        this.forecasts = ApiTypeHelper.requireNonNull(builder.forecasts, this, "forecasts");
        this.modelSize = ApiTypeHelper.requireNonNull(builder.modelSize, this, "modelSize");
    }

    public static JobUsage of(Function<Builder, ObjectBuilder<JobUsage>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    public final Map<String, Long> createdBy() {
        return this.createdBy;
    }

    public final JobStatistics detectors() {
        return this.detectors;
    }

    public final MlJobForecasts forecasts() {
        return this.forecasts;
    }

    public final JobStatistics modelSize() {
        return this.modelSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.createdBy)) {
            generator.writeKey("created_by");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.createdBy.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("detectors");
        this.detectors.serialize(generator, mapper);
        generator.writeKey("forecasts");
        this.forecasts.serialize(generator, mapper);
        generator.writeKey("model_size");
        this.modelSize.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupJobUsageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::createdBy, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "created_by");
        op.add(Builder::detectors, JobStatistics._DESERIALIZER, "detectors");
        op.add(Builder::forecasts, MlJobForecasts._DESERIALIZER, "forecasts");
        op.add(Builder::modelSize, JobStatistics._DESERIALIZER, "model_size");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<JobUsage> {
        private Integer count;
        private Map<String, Long> createdBy;
        private JobStatistics detectors;
        private MlJobForecasts forecasts;
        private JobStatistics modelSize;

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder createdBy(Map<String, Long> map) {
            this.createdBy = Builder._mapPutAll(this.createdBy, map);
            return this;
        }

        public final Builder createdBy(String key, Long value) {
            this.createdBy = Builder._mapPut(this.createdBy, key, value);
            return this;
        }

        public final Builder detectors(JobStatistics value) {
            this.detectors = value;
            return this;
        }

        public final Builder detectors(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.detectors(fn.apply(new JobStatistics.Builder()).build());
        }

        public final Builder forecasts(MlJobForecasts value) {
            this.forecasts = value;
            return this;
        }

        public final Builder forecasts(Function<MlJobForecasts.Builder, ObjectBuilder<MlJobForecasts>> fn) {
            return this.forecasts(fn.apply(new MlJobForecasts.Builder()).build());
        }

        public final Builder modelSize(JobStatistics value) {
            this.modelSize = value;
            return this;
        }

        public final Builder modelSize(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.modelSize(fn.apply(new JobStatistics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JobUsage build() {
            this._checkSingleUse();
            return new JobUsage(this);
        }
    }
}

