/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.BulkError;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BulkUpdateApiKeysResponse
implements JsonpSerializable {
    @Nullable
    private final BulkError errors;
    private final List<String> noops;
    private final List<String> updated;
    public static final JsonpDeserializer<BulkUpdateApiKeysResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkUpdateApiKeysResponse::setupBulkUpdateApiKeysResponseDeserializer);

    private BulkUpdateApiKeysResponse(Builder builder) {
        this.errors = builder.errors;
        this.noops = ApiTypeHelper.unmodifiableRequired(builder.noops, (Object)this, "noops");
        this.updated = ApiTypeHelper.unmodifiableRequired(builder.updated, (Object)this, "updated");
    }

    public static BulkUpdateApiKeysResponse of(Function<Builder, ObjectBuilder<BulkUpdateApiKeysResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final BulkError errors() {
        return this.errors;
    }

    public final List<String> noops() {
        return this.noops;
    }

    public final List<String> updated() {
        return this.updated;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.errors != null) {
            generator.writeKey("errors");
            this.errors.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.noops)) {
            generator.writeKey("noops");
            generator.writeStartArray();
            for (String item0 : this.noops) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.updated)) {
            generator.writeKey("updated");
            generator.writeStartArray();
            for (String item0 : this.updated) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupBulkUpdateApiKeysResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::errors, BulkError._DESERIALIZER, "errors");
        op.add(Builder::noops, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "noops");
        op.add(Builder::updated, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "updated");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<BulkUpdateApiKeysResponse> {
        @Nullable
        private BulkError errors;
        private List<String> noops;
        private List<String> updated;

        public final Builder errors(@Nullable BulkError value) {
            this.errors = value;
            return this;
        }

        public final Builder errors(Function<BulkError.Builder, ObjectBuilder<BulkError>> fn) {
            return this.errors(fn.apply(new BulkError.Builder()).build());
        }

        public final Builder noops(List<String> list) {
            this.noops = Builder._listAddAll(this.noops, list);
            return this;
        }

        public final Builder noops(String value, String ... values) {
            this.noops = Builder._listAdd(this.noops, value, values);
            return this;
        }

        public final Builder updated(List<String> list) {
            this.updated = Builder._listAddAll(this.updated, list);
            return this;
        }

        public final Builder updated(String value, String ... values) {
            this.updated = Builder._listAdd(this.updated, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BulkUpdateApiKeysResponse build() {
            this._checkSingleUse();
            return new BulkUpdateApiKeysResponse(this);
        }
    }
}

