/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.SyncJobPostResponse;
import co.elastic.clients.elasticsearch.connector.SyncJobTriggerMethod;
import co.elastic.clients.elasticsearch.connector.SyncJobType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SyncJobPostRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final SyncJobType jobType;
    @Nullable
    private final SyncJobTriggerMethod triggerMethod;
    public static final JsonpDeserializer<SyncJobPostRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SyncJobPostRequest::setupSyncJobPostRequestDeserializer);
    public static final Endpoint<SyncJobPostRequest, SyncJobPostResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SyncJobPostRequest, SyncJobPostResponse>("es/connector.sync_job_post", request -> "POST", request -> "/_connector/_sync_job", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, SyncJobPostResponse._DESERIALIZER);

    private SyncJobPostRequest(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.jobType = builder.jobType;
        this.triggerMethod = builder.triggerMethod;
    }

    public static SyncJobPostRequest of(Function<Builder, ObjectBuilder<SyncJobPostRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final SyncJobType jobType() {
        return this.jobType;
    }

    @Nullable
    public final SyncJobTriggerMethod triggerMethod() {
        return this.triggerMethod;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        if (this.jobType != null) {
            generator.writeKey("job_type");
            this.jobType.serialize(generator, mapper);
        }
        if (this.triggerMethod != null) {
            generator.writeKey("trigger_method");
            this.triggerMethod.serialize(generator, mapper);
        }
    }

    protected static void setupSyncJobPostRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::jobType, SyncJobType._DESERIALIZER, "job_type");
        op.add(Builder::triggerMethod, SyncJobTriggerMethod._DESERIALIZER, "trigger_method");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SyncJobPostRequest> {
        private String id;
        @Nullable
        private SyncJobType jobType;
        @Nullable
        private SyncJobTriggerMethod triggerMethod;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder jobType(@Nullable SyncJobType value) {
            this.jobType = value;
            return this;
        }

        public final Builder triggerMethod(@Nullable SyncJobTriggerMethod value) {
            this.triggerMethod = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SyncJobPostRequest build() {
            this._checkSingleUse();
            return new SyncJobPostRequest(this);
        }
    }
}

