"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _filter_item = require("./filter_item");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Properties for the filter items component, which will render a single filter pill for every filter that is sent in
 * as part of the `Filter[]` property.
 */

const FilterItemsUI = /*#__PURE__*/_react.default.memo(function FilterItemsUI(props) {
  const groupRef = (0, _react.useRef)(null);
  const kibana = (0, _public.useKibana)();
  const {
    appName,
    data,
    usageCollection,
    uiSettings,
    docLinks
  } = kibana.services;
  const {
    readOnly = false
  } = props;
  if (!uiSettings) return null;
  const reportUiCounter = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter.bind(usageCollection, appName);
  function onFiltersUpdated(filters) {
    if (props.onFiltersUpdated) {
      props.onFiltersUpdated(filters);
    }
  }
  function renderItems() {
    return props.filters.map((filter, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: i,
      grow: false,
      css: (0, _react2.css)`
          max-width: 100%;
        `
    }, /*#__PURE__*/_react.default.createElement(_filter_item.FilterItem, {
      id: `${i}`,
      intl: props.intl,
      filter: filter,
      onUpdate: newFilter => onUpdate(i, newFilter),
      onRemove: () => onRemove(i),
      indexPatterns: props.indexPatterns,
      uiSettings: uiSettings,
      docLinks: docLinks,
      hiddenPanelOptions: props.hiddenPanelOptions,
      timeRangeForSuggestionsOverride: props.timeRangeForSuggestionsOverride,
      filtersForSuggestions: props.filtersForSuggestions,
      readOnly: readOnly,
      suggestionsAbstraction: props.suggestionsAbstraction,
      filtersCount: props.filters.length,
      dataViews: data === null || data === void 0 ? void 0 : data.dataViews
    })));
  }
  function onRemove(i) {
    var _groupRef$current;
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:removed`);
    const filters = [...props.filters];
    filters.splice(i, 1);
    onFiltersUpdated(filters);
    (_groupRef$current = groupRef.current) === null || _groupRef$current === void 0 ? void 0 : _groupRef$current.focus();
  }
  function onUpdate(i, filter) {
    reportUiCounter === null || reportUiCounter === void 0 ? void 0 : reportUiCounter(_analytics.METRIC_TYPE.CLICK, `filter:edited`);
    const filters = [...props.filters];
    filters[i] = filter;
    onFiltersUpdated(filters);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderItems());
});
const FilterItems = exports.FilterItems = (0, _i18nReact.injectI18n)(FilterItemsUI);