"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterBadgeGroup = FilterBadgeGroup;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _filter_badge_error_boundary = require("./filter_badge_error_boundary");
var _filter_badge_expression = require("./filter_badge_expression");
var _filter_badge = require("./filter_badge.styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const BooleanRelationDelimiter = ({
  conditional
}) => {
  /**
   *  Spaces have been added to make the title readable.
   */
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    className: _filter_badge.conditionCss
  }, ` ${conditional} `);
};
function FilterBadgeGroup({
  filters,
  dataViews,
  filterLabelStatus,
  booleanRelation,
  shouldShowBrackets = true
}) {
  return /*#__PURE__*/_react.default.createElement(_filter_badge_error_boundary.FilterBadgeErrorBoundary, null, filters.map((filter, index, filterArr) => {
    const showRelationDelimiter = booleanRelation && index + 1 < filterArr.length;
    const showBrackets = shouldShowBrackets && (filter.meta.negate || filterArr.length > 1);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_filter_badge_expression.FilterExpressionBadge, {
      filter: filter,
      shouldShowBrackets: showBrackets,
      dataViews: dataViews,
      filterLabelStatus: filterLabelStatus
    }), showRelationDelimiter && /*#__PURE__*/_react.default.createElement(BooleanRelationDelimiter, {
      conditional: booleanRelation
    }));
  }));
}