"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionOverview = TransactionOverview;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _src = require("@kbn/discover-utils/src");
var _use_data_view_fields = require("../../../../hooks/use_data_view_fields");
var _use_field_actions = require("../../../../hooks/use_field_actions");
var _fields = require("./resources/fields");
var _get_transaction_field_configuration = require("./resources/get_transaction_field_configuration");
var _transaction_summary_field = require("./sub_components/transaction_summary_field");
var _transaction_duration_summary = require("./sub_components/transaction_duration_summary");
var _use_root_transaction = require("./hooks/use_root_transaction");
var _trace = require("../components/trace");
var _transaction_summary_title = require("./sub_components/transaction_summary_title");
var _plugin = require("../../../../plugin");
var _use_data_sources = require("../hooks/use_data_sources");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function TransactionOverview({
  columns,
  hit,
  filter,
  onAddColumn,
  onRemoveColumn,
  indexes,
  showWaterfall = true,
  showActions = true,
  dataView,
  columnsMeta
}) {
  const {
    fieldFormats
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const {
    formattedDoc,
    flattenedDoc
  } = (0, _react.useMemo)(() => ({
    formattedDoc: (0, _discoverUtils.getTransactionDocumentOverview)(hit, {
      dataView,
      fieldFormats
    }),
    flattenedDoc: (0, _src.getFlattenedTransactionDocumentOverview)(hit)
  }), [dataView, fieldFormats, hit]);
  const {
    dataViewFields
  } = (0, _use_data_view_fields.useDataViewFields)({
    fields: _fields.allTransactionFields,
    dataView,
    columnsMeta
  });
  const transactionDuration = flattenedDoc[_discoverUtils.TRANSACTION_DURATION_FIELD];
  const fieldConfigurations = (0, _react.useMemo)(() => (0, _get_transaction_field_configuration.getTransactionFieldConfiguration)({
    attributes: formattedDoc,
    flattenedDoc
  }), [formattedDoc, flattenedDoc]);
  const traceId = flattenedDoc[_discoverUtils.TRACE_ID_FIELD];
  const transactionId = flattenedDoc[_discoverUtils.TRANSACTION_ID_FIELD];
  return /*#__PURE__*/_react.default.createElement(_use_data_sources.DataSourcesProvider, {
    indexes: indexes
  }, /*#__PURE__*/_react.default.createElement(_use_root_transaction.RootTransactionProvider, {
    traceId: traceId,
    indexPattern: indexes.apm.traces
  }, /*#__PURE__*/_react.default.createElement(_use_field_actions.FieldActionsProvider, {
    columns: columns,
    filter: filter,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_transaction_summary_title.TransactionSummaryTitle, {
    serviceName: flattenedDoc[_discoverUtils.SERVICE_NAME_FIELD],
    transactionName: flattenedDoc[_discoverUtils.TRANSACTION_NAME_FIELD],
    formattedTransactionName: formattedDoc[_discoverUtils.TRANSACTION_NAME_FIELD],
    id: transactionId,
    formattedId: formattedDoc[_discoverUtils.TRANSACTION_ID_FIELD],
    showActions: showActions
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _fields.transactionFields.map(fieldId => /*#__PURE__*/_react.default.createElement(_transaction_summary_field.TransactionSummaryField, {
    key: fieldId,
    fieldId: fieldId,
    fieldMapping: dataViewFields[fieldId],
    fieldConfiguration: fieldConfigurations[fieldId],
    showActions: showActions
  }))), transactionDuration !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_transaction_duration_summary.TransactionDurationSummary, {
    transactionDuration: transactionDuration,
    transactionName: formattedDoc[_discoverUtils.TRANSACTION_NAME_FIELD],
    transactionType: formattedDoc[_discoverUtils.TRANSACTION_TYPE_FIELD],
    serviceName: formattedDoc[_discoverUtils.SERVICE_NAME_FIELD]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, traceId && transactionId && /*#__PURE__*/_react.default.createElement(_trace.Trace, {
    fields: fieldConfigurations,
    fieldMappings: dataViewFields,
    traceId: traceId,
    docId: transactionId,
    displayType: "transaction",
    dataView: dataView,
    tracesIndexPattern: indexes.apm.traces,
    showWaterfall: showWaterfall,
    showActions: showActions
  })))))));
}